/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Util;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildAuthorizationToken;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.queue.QueueTaskFuture;
import hudson.search.SearchIndexBuilder;
import hudson.triggers.Trigger;
import hudson.triggers.TriggerDescriptor;
import hudson.util.AlternativeUiTextProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import jenkins.util.TimeDuration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class ParameterizedJobMixIn<JobT extends Job<JobT, RunT> & Queue.Task, RunT extends Run<JobT, RunT>> {
    public static final AlternativeUiTextProvider.Message<ParameterizedJob> BUILD_NOW_TEXT = new AlternativeUiTextProvider.Message();

    protected abstract JobT asJob();

    public final boolean scheduleBuild() {
        return this.scheduleBuild(((ParameterizedJob)this.asJob()).getQuietPeriod(), new Cause.LegacyCodeCause());
    }

    public final boolean scheduleBuild(Cause c) {
        return this.scheduleBuild(((ParameterizedJob)this.asJob()).getQuietPeriod(), c);
    }

    public final boolean scheduleBuild(int quietPeriod) {
        return this.scheduleBuild(quietPeriod, new Cause.LegacyCodeCause());
    }

    public final boolean scheduleBuild(int quietPeriod, Cause c) {
        return this.scheduleBuild2(quietPeriod, c != null ? Collections.singletonList(new CauseAction(c)) : Collections.emptyList()) != null;
    }

    @CheckForNull
    public final QueueTaskFuture<RunT> scheduleBuild2(int quietPeriod, Action ... actions) {
        Queue.Item i = this.scheduleBuild2(quietPeriod, Arrays.asList(actions));
        return i != null ? i.getFuture() : null;
    }

    @CheckForNull
    public static Queue.Item scheduleBuild2(final Job<?, ?> job, int quietPeriod, Action ... actions) {
        if (!(job instanceof ParameterizedJob)) {
            return null;
        }
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        }.scheduleBuild2(quietPeriod == -1 ? ((ParameterizedJob)((Object)job)).getQuietPeriod() : quietPeriod, Arrays.asList(actions));
    }

    @CheckForNull
    Queue.Item scheduleBuild2(int quietPeriod, List<Action> actions) {
        if (!((Job)this.asJob()).isBuildable()) {
            return null;
        }
        ArrayList<Action> queueActions = new ArrayList<Action>(actions);
        if (this.isParameterized() && Util.filter(queueActions, ParametersAction.class).isEmpty()) {
            queueActions.add(new ParametersAction(this.getDefaultParametersValues()));
        }
        return Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.asJob(), quietPeriod, queueActions).getItem();
    }

    private List<ParameterValue> getDefaultParametersValues() {
        ParametersDefinitionProperty paramDefProp = ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        if (paramDefProp == null) {
            return defValues;
        }
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    public final boolean isParameterized() {
        return ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class) != null;
    }

    public final void doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        if (delay == null) {
            delay = new TimeDuration(((ParameterizedJob)this.asJob()).getQuietPeriod());
        }
        if (!((Job)this.asJob()).isBuildable()) {
            throw HttpResponses.error((int)409, (Throwable)new IOException(((AbstractItem)this.asJob()).getFullName() + " is not buildable"));
        }
        ParametersDefinitionProperty pp = ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class);
        if (pp != null && !req.getMethod().equals("POST")) {
            req.getView((Object)pp, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        BuildAuthorizationToken.checkPermission(this.asJob(), ((ParameterizedJob)this.asJob()).getAuthToken(), req, rsp);
        if (pp != null) {
            pp._doBuild(req, rsp, delay);
            return;
        }
        Queue.Item item = Jenkins.getInstance().getQueue().schedule2((Queue.Task)this.asJob(), delay.getTime(), ParameterizedJobMixIn.getBuildCause((ParameterizedJob)this.asJob(), req)).getItem();
        if (item != null) {
            rsp.sendRedirect(201, req.getContextPath() + '/' + item.getUrl());
        } else {
            rsp.sendRedirect(".");
        }
    }

    public final void doBuildWithParameters(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
        BuildAuthorizationToken.checkPermission(this.asJob(), ((ParameterizedJob)this.asJob()).getAuthToken(), req, rsp);
        ParametersDefinitionProperty pp = ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class);
        if (!((Job)this.asJob()).isBuildable()) {
            throw HttpResponses.error((int)409, (Throwable)new IOException(((AbstractItem)this.asJob()).getFullName() + " is not buildable!"));
        }
        if (pp == null) {
            throw new IllegalStateException("This build is not parameterized!");
        }
        pp.buildWithParameters(req, rsp, delay);
    }

    @RequirePOST
    public final void doCancelQueue(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        ((AbstractItem)this.asJob()).checkPermission(Item.CANCEL);
        Jenkins.getInstance().getQueue().cancel((Queue.Task)this.asJob());
        rsp.forwardToPreviousPage(req);
    }

    public final SearchIndexBuilder extendSearchIndex(SearchIndexBuilder sib) {
        if (((Job)this.asJob()).isBuildable() && ((AbstractItem)this.asJob()).hasPermission(Item.BUILD)) {
            sib.add("build", "build");
        }
        return sib;
    }

    @Restricted(value={NoExternalUse.class})
    public static final CauseAction getBuildCause(ParameterizedJob job, StaplerRequest req) {
        Cause cause;
        BuildAuthorizationToken authToken = job.getAuthToken();
        if (authToken != null && authToken.getToken() != null && req.getParameter("token") != null) {
            String causeText = req.getParameter("cause");
            cause = new Cause.RemoteCause(req.getRemoteAddr(), causeText);
        } else {
            cause = new Cause.UserIdCause();
        }
        return new CauseAction(cause);
    }

    public final String getBuildNowText() {
        return this.isParameterized() ? AlternativeUiTextProvider.get(BUILD_NOW_TEXT, this.asJob(), Messages.ParameterizedJobMixIn_build_with_parameters()) : AlternativeUiTextProvider.get(BUILD_NOW_TEXT, this.asJob(), Messages.ParameterizedJobMixIn_build_now());
    }

    @CheckForNull
    public static <T extends Trigger<?>> T getTrigger(Job<?, ?> job, Class<T> clazz) {
        if (!(job instanceof ParameterizedJob)) {
            return null;
        }
        for (Trigger<?> t : ((ParameterizedJob)((Object)job)).getTriggers().values()) {
            if (!clazz.isInstance(t)) continue;
            return (T)((Trigger)clazz.cast(t));
        }
        return null;
    }

    public static interface ParameterizedJob
    extends Queue.Task,
    Item {
        @CheckForNull
        public BuildAuthorizationToken getAuthToken();

        public int getQuietPeriod();

        public String getBuildNowText();

        public Map<TriggerDescriptor, Trigger<?>> getTriggers();
    }
}

