/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import hudson.model.Executor;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public abstract class AsynchronousExecution
extends RuntimeException {
    @GuardedBy(value="this")
    private Executor executor;
    @CheckForNull
    @GuardedBy(value="this")
    private Throwable result;
    private static final Throwable NULL = new Throwable("NULL");

    protected AsynchronousExecution() {
    }

    public abstract void interrupt(boolean var1);

    public abstract boolean blocksRestart();

    public abstract boolean displayCell();

    @CheckForNull
    public final synchronized Executor getExecutor() {
        return this.executor;
    }

    @Restricted(value={NoExternalUse.class})
    public final synchronized void setExecutor(@Nonnull Executor executor) {
        assert (this.executor == null);
        this.executor = executor;
        if (this.result != null) {
            executor.completedAsynchronous(this.result != NULL ? this.result : null);
            this.result = null;
        }
    }

    public final synchronized void completed(@CheckForNull Throwable error) {
        if (this.executor != null) {
            this.executor.completedAsynchronous(error);
        } else {
            this.result = error == null ? NULL : error;
        }
    }
}

