/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.AuthenticationTrustResolver;
import org.acegisecurity.AuthenticationTrustResolverImpl;
import org.acegisecurity.InsufficientAuthenticationException;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.ui.AccessDeniedHandler;
import org.acegisecurity.ui.AccessDeniedHandlerImpl;
import org.acegisecurity.ui.AuthenticationEntryPoint;
import org.acegisecurity.ui.savedrequest.SavedRequest;
import org.acegisecurity.util.PortResolver;
import org.acegisecurity.util.PortResolverImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class ExceptionTranslationFilter
implements Filter,
InitializingBean {
    private static final Logger LOGGER = Logger.getLogger(ExceptionTranslationFilter.class.getName());
    private AccessDeniedHandler accessDeniedHandler = new AccessDeniedHandlerImpl();
    private AuthenticationEntryPoint authenticationEntryPoint;
    private AuthenticationTrustResolver authenticationTrustResolver = new AuthenticationTrustResolverImpl();
    private PortResolver portResolver = new PortResolverImpl();
    private boolean createSessionAllowed = true;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationEntryPoint, (String)"authenticationEntryPoint must be specified");
        Assert.notNull((Object)this.portResolver, (String)"portResolver must be specified");
        Assert.notNull((Object)this.authenticationTrustResolver, (String)"authenticationTrustResolver must be specified");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("HttpServletRequest required");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("HttpServletResponse required");
        }
        try {
            chain.doFilter(request, response);
            LOGGER.finer("Chain processed normally");
        }
        catch (AuthenticationException ex) {
            this.handleException(request, response, chain, (AcegiSecurityException)ex);
        }
        catch (AccessDeniedException ex) {
            this.handleException(request, response, chain, (AcegiSecurityException)ex);
        }
        catch (ServletException ex) {
            if (ex.getRootCause() instanceof AuthenticationException || ex.getRootCause() instanceof AccessDeniedException) {
                this.handleException(request, response, chain, (AcegiSecurityException)ex.getRootCause());
            }
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return this.authenticationEntryPoint;
    }

    public AuthenticationTrustResolver getAuthenticationTrustResolver() {
        return this.authenticationTrustResolver;
    }

    public PortResolver getPortResolver() {
        return this.portResolver;
    }

    private void handleException(ServletRequest request, ServletResponse response, FilterChain chain, AcegiSecurityException exception) throws IOException, ServletException {
        if (exception instanceof AuthenticationException) {
            LOGGER.log(Level.FINER, "Authentication exception occurred; redirecting to authentication entry point", (Throwable)exception);
            this.sendStartAuthentication(request, response, chain, (AuthenticationException)exception);
        } else if (exception instanceof AccessDeniedException) {
            if (this.authenticationTrustResolver.isAnonymous(SecurityContextHolder.getContext().getAuthentication())) {
                LOGGER.log(Level.FINER, "Access is denied (user is anonymous); redirecting to authentication entry point", (Throwable)exception);
                this.sendStartAuthentication(request, response, chain, (AuthenticationException)new InsufficientAuthenticationException("Full authentication is required to access this resource", (Throwable)exception));
            } else {
                LOGGER.log(Level.FINER, "Access is denied (user is not anonymous); delegating to AccessDeniedHandler", (Throwable)exception);
                this.accessDeniedHandler.handle(request, response, (AccessDeniedException)exception);
            }
        }
    }

    public boolean isCreateSessionAllowed() {
        return this.createSessionAllowed;
    }

    protected void sendStartAuthentication(ServletRequest request, ServletResponse response, FilterChain chain, AuthenticationException reason) throws ServletException, IOException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        SavedRequest savedRequest = new SavedRequest(httpRequest, this.portResolver);
        LOGGER.finer("Authentication entry point being called; SavedRequest added to Session: " + savedRequest);
        if (this.createSessionAllowed) {
            httpRequest.getSession().setAttribute("ACEGI_SAVED_REQUEST_KEY", (Object)savedRequest);
        }
        SecurityContextHolder.getContext().setAuthentication(null);
        this.authenticationEntryPoint.commence((ServletRequest)httpRequest, response, reason);
    }

    public void setAccessDeniedHandler(AccessDeniedHandler accessDeniedHandler) {
        Assert.notNull((Object)accessDeniedHandler, (String)"AccessDeniedHandler required");
        this.accessDeniedHandler = accessDeniedHandler;
    }

    public void setAuthenticationEntryPoint(AuthenticationEntryPoint authenticationEntryPoint) {
        this.authenticationEntryPoint = authenticationEntryPoint;
    }

    public void setAuthenticationTrustResolver(AuthenticationTrustResolver authenticationTrustResolver) {
        this.authenticationTrustResolver = authenticationTrustResolver;
    }

    public void setCreateSessionAllowed(boolean createSessionAllowed) {
        this.createSessionAllowed = createSessionAllowed;
    }

    public void setPortResolver(PortResolver portResolver) {
        this.portResolver = portResolver;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

