/*
 * Decompiled with CFR 0.152.
 */
package jenkins.security;

import hudson.remoting.Base64;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import jenkins.security.RSAConfidentialKey;

public class RSADigitalSignatureConfidentialKey
extends RSAConfidentialKey {
    static final String SIGNING_ALGORITHM = "SHA256";

    public RSADigitalSignatureConfidentialKey(String id) {
        super(id);
    }

    public RSADigitalSignatureConfidentialKey(Class owner, String shortName) {
        super(owner, shortName);
    }

    public String sign(String msg) {
        try {
            RSAPrivateKey key = this.getPrivateKey();
            Signature sig = Signature.getInstance("SHA256with" + key.getAlgorithm());
            sig.initSign(key);
            sig.update(msg.getBytes("UTF-8"));
            return Base64.encode((byte[])sig.sign());
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }
}

