/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyCodeSource;
import groovy.lang.GroovyShell;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;

public class GroovyHookScript {
    private final String hook;
    private final Binding bindings = new Binding();
    private final ServletContext servletContext;
    private final File home;
    private final ClassLoader loader;
    private static final Logger LOGGER = Logger.getLogger(GroovyHookScript.class.getName());

    @Deprecated
    public GroovyHookScript(String hook) {
        this(hook, Jenkins.getActiveInstance());
    }

    private GroovyHookScript(String hook, Jenkins j) {
        this(hook, j.servletContext, j.getRootDir(), j.getPluginManager().uberClassLoader);
    }

    public GroovyHookScript(String hook, @Nonnull ServletContext servletContext, @Nonnull File home, @Nonnull ClassLoader loader) {
        this.hook = hook;
        this.servletContext = servletContext;
        this.home = home;
        this.loader = loader;
    }

    public GroovyHookScript bind(String name, Object o) {
        this.bindings.setProperty(name, o);
        return this;
    }

    public Binding getBindings() {
        return this.bindings;
    }

    public void run() {
        Object[] scripts;
        String hookGroovy = this.hook + ".groovy";
        String hookGroovyD = this.hook + ".groovy.d";
        try {
            URL bundled = this.servletContext.getResource("/WEB-INF/" + hookGroovy);
            this.execute(bundled);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to execute /WEB-INF/" + hookGroovy, e);
        }
        Set resources = this.servletContext.getResourcePaths("/WEB-INF/" + hookGroovyD + "/");
        if (resources != null) {
            for (String res : new TreeSet(resources)) {
                try {
                    URL bundled = this.servletContext.getResource(res);
                    this.execute(bundled);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Failed to execute " + res, e);
                }
            }
        }
        File script = new File(this.home, hookGroovy);
        this.execute(script);
        File scriptD = new File(this.home, hookGroovyD);
        if (scriptD.isDirectory() && (scripts = scriptD.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".groovy");
            }
        })) != null) {
            Arrays.sort(scripts);
            for (Object f : scripts) {
                this.execute((File)f);
            }
        }
    }

    protected void execute(URL bundled) throws IOException {
        if (bundled != null) {
            LOGGER.info("Executing bundled script: " + bundled);
            this.execute(new GroovyCodeSource(bundled));
        }
    }

    protected void execute(File f) {
        if (f.exists()) {
            LOGGER.info("Executing " + f);
            try {
                this.execute(new GroovyCodeSource(f));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to execute " + f, e);
            }
        }
    }

    protected void execute(GroovyCodeSource s) {
        try {
            this.createShell().evaluate(s);
        }
        catch (RuntimeException x) {
            LOGGER.log(Level.WARNING, "Failed to run script " + s.getName(), x);
        }
    }

    protected GroovyShell createShell() {
        return new GroovyShell(this.loader, this.bindings);
    }
}

