/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers.ldap.authenticator;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.ldap.InitialDirContextFactory;
import org.acegisecurity.providers.ldap.authenticator.BindAuthenticator;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;

public class BindAuthenticator2
extends BindAuthenticator {
    private boolean hadSuccessfulAuthentication;
    private static final Logger LOGGER = Logger.getLogger(BindAuthenticator2.class.getName());

    public BindAuthenticator2(InitialDirContextFactory initialDirContextFactory) {
        super(initialDirContextFactory);
    }

    public LdapUserDetails authenticate(String username, String password) {
        LdapUserDetails user = super.authenticate(username, password);
        this.hadSuccessfulAuthentication = true;
        return user;
    }

    void handleBindException(String userDn, String username, Throwable cause) {
        LOGGER.log(this.hadSuccessfulAuthentication ? Level.FINE : Level.WARNING, "Failed to bind to LDAP: userDn" + userDn + "  username=" + username, cause);
        super.handleBindException(userDn, username, cause);
    }
}

