/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.ExtensionPoint;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.UpdateSite;
import hudson.util.FormValidation;
import hudson.util.TextFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
public class DownloadService {
    private static final String signatureValidatorPrefix = "downloadable";
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean neverUpdate = SystemProperties.getBoolean(DownloadService.class.getName() + ".never");
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean signatureCheck = !SystemProperties.getBoolean(DownloadService.class.getName() + ".noSignatureCheck");

    @Deprecated
    public String generateFragment() {
        return "";
    }

    public Downloadable getById(String id) {
        for (Downloadable d : Downloadable.all()) {
            if (!d.getId().equals(id)) continue;
            return d;
        }
        return null;
    }

    @Restricted(value={NoExternalUse.class})
    public static String loadJSON(URL src) throws IOException {
        URLConnection con = ProxyConfiguration.open(src);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
        }
        try (InputStream is = con.getInputStream();){
            String jsonp = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            int start = jsonp.indexOf(123);
            int end = jsonp.lastIndexOf(125);
            if (start >= 0 && end > start) {
                String string = jsonp.substring(start, end + 1);
                return string;
            }
            throw new IOException("Could not find JSON in " + src);
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static String loadJSONHTML(URL src) throws IOException {
        URLConnection con = ProxyConfiguration.open(src);
        if (con instanceof HttpURLConnection) {
            ((HttpURLConnection)con).setInstanceFollowRedirects(true);
        }
        try (InputStream is = con.getInputStream();){
            String jsonp = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            String preamble = "window.parent.postMessage(JSON.stringify(";
            int start = jsonp.indexOf(preamble);
            int end = jsonp.lastIndexOf("),'*');");
            if (start >= 0 && end > start) {
                String string = jsonp.substring(start + preamble.length(), end).trim();
                return string;
            }
            throw new IOException("Could not find JSON in " + src);
        }
    }

    public static class Downloadable
    implements ExtensionPoint {
        private final String id;
        private final String url;
        private final long interval;
        private volatile long due = 0L;
        private volatile long lastAttempt = Long.MIN_VALUE;
        private static final Logger LOGGER = Logger.getLogger(Downloadable.class.getName());
        private static final long DEFAULT_INTERVAL = SystemProperties.getLong(Downloadable.class.getName() + ".defaultInterval", TimeUnit.DAYS.toMillis(1L));

        public Downloadable(@NonNull String id, @NonNull String url, long interval) {
            this.id = id;
            this.url = url;
            this.interval = interval;
        }

        public Downloadable() {
            this.id = Downloadable.idFor(this.getClass());
            this.url = this.id + ".json";
            this.interval = DEFAULT_INTERVAL;
        }

        public Downloadable(@NonNull Class<?> clazz) {
            this(Downloadable.idFor(clazz));
        }

        public Downloadable(@NonNull String id) {
            this(id, id + ".json");
        }

        public Downloadable(@NonNull String id, @NonNull String url) {
            this(id, url, DEFAULT_INTERVAL);
        }

        @NonNull
        public String getId() {
            return this.id;
        }

        @NonNull
        public static String idFor(@NonNull Class<?> clazz) {
            return clazz.getName().replace('$', '.');
        }

        public String getUrl() {
            return Jenkins.get().getUpdateCenter().getDefaultBaseUrl() + "updates/" + this.url;
        }

        public List<String> getUrls() {
            ArrayList<String> updateSites = new ArrayList<String>();
            for (UpdateSite site : Jenkins.get().getUpdateCenter().getSiteList()) {
                String siteUrl = site.getUrl();
                int baseUrlEnd = siteUrl.indexOf("update-center.json");
                if (baseUrlEnd != -1) {
                    String siteBaseUrl = siteUrl.substring(0, baseUrlEnd);
                    updateSites.add(siteBaseUrl + "updates/" + this.url);
                    continue;
                }
                LOGGER.log(Level.WARNING, "Url {0} does not look like an update center:", siteUrl);
            }
            return updateSites;
        }

        public long getInterval() {
            return this.interval;
        }

        public TextFile getDataFile() {
            return new TextFile(new File(Jenkins.get().getRootDir(), "updates/" + this.id));
        }

        public long getDue() {
            if (this.due == 0L) {
                this.due = this.getDataFile().file.lastModified() + this.interval;
            }
            return this.due;
        }

        public JSONObject getData() throws IOException {
            TextFile df = this.getDataFile();
            if (df.exists()) {
                try {
                    return JSONObject.fromObject((Object)df.read());
                }
                catch (JSONException e) {
                    IOException ioe = new IOException("Failed to parse " + df + " into JSON", e);
                    try {
                        df.delete();
                    }
                    catch (IOException e2) {
                        ioe.addSuppressed(e2);
                    }
                    throw ioe;
                }
            }
            return null;
        }

        private FormValidation load(String json, long dataTimestamp) throws IOException {
            TextFile df = this.getDataFile();
            df.write(json);
            Files.setLastModifiedTime(Util.fileToPath(df.file), FileTime.fromMillis(dataTimestamp));
            LOGGER.info("Obtained the updated data file for " + this.id);
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation updateNow() throws IOException {
            ArrayList<JSONObject> jsonList = new ArrayList<JSONObject>();
            boolean toolInstallerMetadataExists = false;
            for (UpdateSite updatesite : Jenkins.get().getUpdateCenter().getSiteList()) {
                String jsonString;
                String site = updatesite.getMetadataUrlForDownloadable(this.url);
                if (site == null) {
                    return FormValidation.warning("The update site " + updatesite.getId() + " does not look like an update center");
                }
                try {
                    jsonString = DownloadService.loadJSONHTML(new URL(site + ".html?id=" + URLEncoder.encode(this.getId(), StandardCharsets.UTF_8) + "&version=" + URLEncoder.encode(Jenkins.VERSION, StandardCharsets.UTF_8)));
                    toolInstallerMetadataExists = true;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Could not load json from " + site, e);
                    continue;
                }
                JSONObject o = JSONObject.fromObject((Object)jsonString);
                if (signatureCheck) {
                    FormValidation e = updatesite.getJsonSignatureValidator("downloadable '" + this.id + "'").verifySignature(o);
                    if (e.kind != FormValidation.Kind.OK) {
                        LOGGER.log(Level.WARNING, "signature check failed for " + site, e);
                        continue;
                    }
                }
                jsonList.add(o);
            }
            if (jsonList.isEmpty() && toolInstallerMetadataExists) {
                return FormValidation.warning("None of the tool installer metadata passed the signature check");
            }
            if (!toolInstallerMetadataExists) {
                LOGGER.log(Level.WARNING, "No tool installer metadata found for " + this.id);
                return FormValidation.ok();
            }
            JSONObject reducedJson = this.reduce(jsonList);
            return this.load(reducedJson.toString(), System.currentTimeMillis());
        }

        public JSONObject reduce(List<JSONObject> jsonList) {
            return jsonList.get(0);
        }

        public static <T> boolean hasDuplicates(List<T> genericList, String comparator) {
            Field field;
            if (genericList.isEmpty()) {
                return false;
            }
            try {
                field = genericList.get(0).getClass().getDeclaredField(comparator);
            }
            catch (NoSuchFieldException e) {
                LOGGER.warning("comparator: " + comparator + "does not exist for " + genericList.get(0).getClass() + ", " + e);
                return false;
            }
            for (int i = 0; i < genericList.size(); ++i) {
                T data1 = genericList.get(i);
                for (int j = i + 1; j < genericList.size(); ++j) {
                    T data2 = genericList.get(j);
                    try {
                        if (!field.get(data1).equals(field.get(data2))) continue;
                        return true;
                    }
                    catch (IllegalAccessException e) {
                        LOGGER.warning("could not access field: " + comparator + ", " + e);
                    }
                }
            }
            return false;
        }

        @NonNull
        public static ExtensionList<Downloadable> all() {
            return ExtensionList.lookup(Downloadable.class);
        }

        @CheckForNull
        public static Downloadable get(@NonNull Class<?> clazz) {
            return Downloadable.get(Downloadable.idFor(clazz));
        }

        @CheckForNull
        public static Downloadable get(String id) {
            for (Downloadable d : Downloadable.all()) {
                if (!d.id.equals(id)) continue;
                return d;
            }
            return null;
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static class DownloadableListener
    extends ExtensionListListener {
        private static final Logger LOGGER = Logger.getLogger(DownloadableListener.class.getName());

        @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
        public static void installListener() {
            ExtensionList.lookup(Downloadable.class).addListener(new DownloadableListener());
        }

        @Override
        public void onChange() {
            for (Downloadable d : Downloadable.all()) {
                TextFile f = d.getDataFile();
                if (f == null || !f.exists()) {
                    LOGGER.log(Level.FINE, "Updating metadata for " + d.getId());
                    try {
                        d.updateNow();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to update metadata for " + d.getId(), e);
                    }
                    continue;
                }
                LOGGER.log(Level.FINER, "Skipping update of metadata for " + d.getId());
            }
        }
    }
}

