/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.EnvVars;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.AbstractBuild;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.EnvironmentContributingAction;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Messages;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.labels.LabelAssignmentAction;
import hudson.model.queue.SubTask;
import hudson.tasks.BuildWrapper;
import hudson.util.VariableResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.RunAction2;
import jenkins.util.SystemProperties;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class ParametersAction
implements RunAction2,
Iterable<ParameterValue>,
Queue.QueueAction,
EnvironmentContributingAction,
LabelAssignmentAction {
    @Restricted(value={NoExternalUse.class})
    public static final String KEEP_UNDEFINED_PARAMETERS_SYSTEM_PROPERTY_NAME = ParametersAction.class.getName() + ".keepUndefinedParameters";
    @Restricted(value={NoExternalUse.class})
    public static final String SAFE_PARAMETERS_SYSTEM_PROPERTY_NAME = ParametersAction.class.getName() + ".safeParameters";
    private Set<String> safeParameters;
    @NonNull
    private List<ParameterValue> parameters;
    private List<String> parameterDefinitionNames;
    @Deprecated
    private transient AbstractBuild<?, ?> build;
    private transient Run<?, ?> run;
    private static final Logger LOGGER = Logger.getLogger(ParametersAction.class.getName());

    public ParametersAction(@NonNull List<ParameterValue> parameters) {
        this.parameters = new ArrayList<ParameterValue>(parameters);
        String paramNames = SystemProperties.getString(SAFE_PARAMETERS_SYSTEM_PROPERTY_NAME);
        this.safeParameters = new TreeSet<String>();
        if (paramNames != null) {
            this.safeParameters.addAll(Arrays.asList(paramNames.split(",")));
        }
    }

    public ParametersAction(List<ParameterValue> parameters, Collection<String> additionalSafeParameters) {
        this(parameters);
        if (additionalSafeParameters != null) {
            this.safeParameters.addAll(additionalSafeParameters);
        }
    }

    public ParametersAction(ParameterValue ... parameters) {
        this(Arrays.asList(parameters));
    }

    public void createBuildWrappers(AbstractBuild<?, ?> build, Collection<? super BuildWrapper> result) {
        for (ParameterValue p : this.getParameters()) {
            BuildWrapper w;
            if (p == null || (w = p.createBuildWrapper(build)) == null) continue;
            result.add(w);
        }
    }

    @Override
    public void buildEnvironment(Run<?, ?> run, EnvVars env) {
        for (ParameterValue p : this.getParameters()) {
            if (p == null) continue;
            p.buildEnvironment(run, env);
        }
    }

    public String substitute(AbstractBuild<?, ?> build, String text) {
        return Util.replaceMacro(text, this.createVariableResolver(build));
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        VariableResolver[] resolvers = new VariableResolver[this.getParameters().size() + 1];
        int i = 0;
        for (ParameterValue p : this.getParameters()) {
            if (p == null) continue;
            resolvers[i++] = p.createVariableResolver(build);
        }
        resolvers[i] = build.getBuildVariableResolver();
        return new VariableResolver.Union<String>(resolvers);
    }

    @Override
    public Iterator<ParameterValue> iterator() {
        return this.getParameters().iterator();
    }

    @Exported(visibility=2)
    public List<ParameterValue> getParameters() {
        return Collections.unmodifiableList(this.filter(this.parameters));
    }

    public ParameterValue getParameter(String name) {
        for (ParameterValue p : this.parameters) {
            if (p == null || !p.getName().equals(name)) continue;
            return p;
        }
        return null;
    }

    @Override
    public Label getAssignedLabel(SubTask task) {
        for (ParameterValue p : this.getParameters()) {
            Label l;
            if (p == null || (l = p.getAssignedLabel(task)) == null) continue;
            return l;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return Messages.ParameterAction_DisplayName();
    }

    @Override
    public String getIconFileName() {
        return "symbol-parameters";
    }

    @Override
    public String getUrlName() {
        return "parameters";
    }

    @Override
    public boolean shouldSchedule(List<Action> actions) {
        List<ParametersAction> others = Util.filter(actions, ParametersAction.class);
        if (others.isEmpty()) {
            return !this.parameters.isEmpty();
        }
        HashSet<ParameterValue> params = new HashSet<ParameterValue>();
        for (ParametersAction other : others) {
            params.addAll(other.parameters);
        }
        return !params.equals(new HashSet<ParameterValue>(this.parameters));
    }

    @NonNull
    public ParametersAction createUpdated(Collection<? extends ParameterValue> overrides) {
        if (overrides == null) {
            ParametersAction parametersAction = new ParametersAction(this.parameters);
            parametersAction.safeParameters = this.safeParameters;
            return parametersAction;
        }
        ArrayList<ParameterValue> combinedParameters = new ArrayList<ParameterValue>(overrides);
        HashSet<String> names = new HashSet<String>();
        for (ParameterValue parameterValue : overrides) {
            if (parameterValue == null) continue;
            names.add(parameterValue.getName());
        }
        for (ParameterValue parameterValue : this.parameters) {
            if (parameterValue == null || names.contains(parameterValue.getName())) continue;
            combinedParameters.add(parameterValue);
        }
        return new ParametersAction(combinedParameters, this.safeParameters);
    }

    @NonNull
    public ParametersAction merge(@CheckForNull ParametersAction overrides) {
        if (overrides == null) {
            return new ParametersAction(this.parameters, this.safeParameters);
        }
        ParametersAction parametersAction = this.createUpdated(overrides.parameters);
        TreeSet<String> safe = new TreeSet<String>();
        if (parametersAction.safeParameters != null && this.safeParameters != null) {
            safe.addAll(this.safeParameters);
        }
        if (overrides.safeParameters != null) {
            safe.addAll(overrides.safeParameters);
        }
        parametersAction.safeParameters = safe;
        return parametersAction;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="parameters in readResolve is needed for data migration.")
    private Object readResolve() {
        if (this.parameters == null) {
            this.parameters = Collections.emptyList();
        }
        if (this.build != null) {
            OldDataMonitor.report(this.build, "1.283");
        }
        if (this.safeParameters == null) {
            this.safeParameters = Collections.emptySet();
        }
        return this;
    }

    @Override
    public void onAttached(Run<?, ?> r) {
        ParametersDefinitionProperty p = ((Job)r.getParent()).getProperty(ParametersDefinitionProperty.class);
        this.parameterDefinitionNames = p != null ? new ArrayList<String>(p.getParameterDefinitionNames()) : Collections.emptyList();
        this.run = r;
    }

    @Override
    public void onLoad(Run<?, ?> r) {
        this.run = r;
    }

    private List<? extends ParameterValue> filter(List<ParameterValue> parameters) {
        if (this.run == null) {
            return parameters;
        }
        if (this.parameterDefinitionNames == null) {
            return parameters;
        }
        Boolean shouldKeepFlag = SystemProperties.optBoolean(KEEP_UNDEFINED_PARAMETERS_SYSTEM_PROPERTY_NAME);
        if (shouldKeepFlag != null && shouldKeepFlag.booleanValue()) {
            return parameters;
        }
        ArrayList<ParameterValue> filteredParameters = new ArrayList<ParameterValue>();
        for (ParameterValue v : this.parameters) {
            if (this.parameterDefinitionNames.contains(v.getName()) || this.isSafeParameter(v.getName())) {
                filteredParameters.add(v);
                continue;
            }
            if (shouldKeepFlag != null) continue;
            LOGGER.log(Level.WARNING, "Skipped parameter `{0}` as it is undefined on `{1}` (#{2}). Set `-D{3}=true` to allow undefined parameters to be injected as environment variables or `-D{4}=[comma-separated list]` to whitelist specific parameter names, even though it represents a security breach or `-D{3}=false` to no longer show this message.", new Object[]{v.getName(), ((AbstractItem)this.run.getParent()).getFullName(), this.run.getNumber(), KEEP_UNDEFINED_PARAMETERS_SYSTEM_PROPERTY_NAME, SAFE_PARAMETERS_SYSTEM_PROPERTY_NAME});
        }
        return filteredParameters;
    }

    public List<ParameterValue> getAllParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    private boolean isSafeParameter(String name) {
        return this.safeParameters.contains(name);
    }
}

