/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.FilePath;
import hudson.Functions;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.remoting.VirtualChannel;
import hudson.slaves.WorkspaceList;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.model.Jenkins;
import jenkins.model.ModifiableTopLevelItemGroup;
import jenkins.util.SystemProperties;
import org.jenkinsci.Symbol;

@Extension
@Symbol(value={"workspaceCleanup"})
public class WorkspaceCleanupThread
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceCleanupThread.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean disabled = SystemProperties.getBoolean(WorkspaceCleanupThread.class.getName() + ".disabled");
    public static final int recurrencePeriodHours = SystemProperties.getInteger(WorkspaceCleanupThread.class.getName() + ".recurrencePeriodHours", 24);
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static int retainForDays = SystemProperties.getInteger(WorkspaceCleanupThread.class.getName() + ".retainForDays", 30);

    public WorkspaceCleanupThread() {
        super("Workspace clean-up");
    }

    @Override
    public long getRecurrencePeriod() {
        return (long)recurrencePeriodHours * 3600000L;
    }

    public static void invoke() {
        ExtensionList.lookup(AsyncPeriodicWork.class).get(WorkspaceCleanupThread.class).run();
    }

    @Override
    protected void execute(TaskListener listener) throws InterruptedException, IOException {
        if (disabled) {
            LOGGER.fine("Disabled. Skipping execution");
            return;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        Jenkins j = Jenkins.get();
        nodes.add(j);
        nodes.addAll(j.getNodes());
        for (TopLevelItem item : j.allItems(TopLevelItem.class)) {
            if (item instanceof ModifiableTopLevelItemGroup) continue;
            listener.getLogger().println("Checking " + item.getFullDisplayName());
            for (Node node : nodes) {
                boolean check;
                FilePath ws = node.getWorkspaceFor(item);
                if (ws == null) continue;
                try {
                    check = this.shouldBeDeleted(item, ws, node);
                }
                catch (IOException | InterruptedException x) {
                    Functions.printStackTrace((Throwable)x, listener.error("Failed to check " + node.getDisplayName()));
                    continue;
                }
                if (!check) continue;
                listener.getLogger().println("Deleting " + ws + " on " + node.getDisplayName());
                try {
                    ws.act(new CleanupOldWorkspaces(retainForDays));
                }
                catch (IOException | InterruptedException x) {
                    Functions.printStackTrace((Throwable)x, listener.error("Failed to delete " + ws + " on " + node.getDisplayName()));
                }
            }
        }
    }

    private boolean shouldBeDeleted(@NonNull TopLevelItem item, FilePath dir, @NonNull Node n) throws IOException, InterruptedException {
        Job j;
        if (item instanceof AbstractProject) {
            AbstractProject p = (AbstractProject)((Object)item);
            Node lb = p.getLastBuiltOn();
            LOGGER.log(Level.FINER, "Directory {0} is last built on {1}", new Object[]{dir, lb});
            if (lb != null && lb.equals(n)) {
                LOGGER.log(Level.FINE, "Directory {0} is the last workspace for {1}", new Object[]{dir, p});
                return false;
            }
            if (!p.getScm().processWorkspaceBeforeDeletion(p, dir, n)) {
                LOGGER.log(Level.FINE, "Directory deletion of {0} is vetoed by SCM", dir);
                return false;
            }
        }
        if (item instanceof Job && (j = (Job)((Object)item)).isBuilding()) {
            LOGGER.log(Level.FINE, "Job {0} is building, so not deleting", item.getFullDisplayName());
            return false;
        }
        return true;
    }

    private static class CleanupOldWorkspaces
    extends MasterToSlaveFileCallable<Void> {
        private final int retentionInDays;

        CleanupOldWorkspaces(int retentionInDays) {
            this.retentionInDays = retentionInDays;
        }

        @Override
        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            File[] workspaces = null;
            File parentWs = f.getParentFile();
            if (parentWs != null) {
                workspaces = parentWs.listFiles(new ShouldBeDeletedFilter(this.retentionInDays, f.getName()));
            }
            if (workspaces != null) {
                for (File workspace : workspaces) {
                    LOGGER.log(Level.FINER, "Going to delete directory {0}", workspace);
                    Util.deleteRecursive(Util.fileToPath(workspace), Path::toFile);
                }
            }
            return null;
        }
    }

    private static class ShouldBeDeletedFilter
    implements FileFilter,
    Serializable {
        private final int retentionInDays;
        private final String workspaceBaseName;

        ShouldBeDeletedFilter(int retentionInDays, String workspaceBaseName) {
            this.retentionInDays = retentionInDays;
            this.workspaceBaseName = workspaceBaseName;
        }

        @Override
        public boolean accept(File dir) {
            if (!dir.isDirectory()) {
                return false;
            }
            if (!dir.getName().equals(this.workspaceBaseName) && !dir.getName().startsWith(this.workspaceBaseName + WorkspaceList.COMBINATOR)) {
                return false;
            }
            long now = new Date().getTime();
            if (dir.lastModified() + (long)this.retentionInDays * 86400000L > now) {
                LOGGER.log(Level.FINE, "Directory {0} is only {1} old, so not deleting", new Object[]{dir, Util.getTimeSpanString(now - dir.lastModified())});
                return false;
            }
            return true;
        }
    }
}

