/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.ExtensionPoint;
import io.jenkins.servlet.FilterWrapper;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.CompatibleFilter;

public final class PluginServletFilter
implements CompatibleFilter,
ExtensionPoint {
    private final List<Filter> list = new CopyOnWriteArrayList<Filter>();
    private FilterConfig config;
    private static final List<Filter> LEGACY = new Vector<Filter>();
    private static final String KEY = PluginServletFilter.class.getName();
    private static final Logger LOGGER = Logger.getLogger(PluginServletFilter.class.getName());

    @CheckForNull
    private static PluginServletFilter getInstance(ServletContext c) {
        return (PluginServletFilter)c.getAttribute(KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(FilterConfig config) throws jakarta.servlet.ServletException {
        this.config = config;
        List<Filter> list = LEGACY;
        synchronized (list) {
            this.list.addAll(LEGACY);
            LEGACY.clear();
        }
        for (Filter f : this.list) {
            f.init(config);
        }
        config.getServletContext().setAttribute(KEY, (Object)this);
    }

    public static void addFilter(Filter filter) throws jakarta.servlet.ServletException {
        Jenkins j = Jenkins.getInstanceOrNull();
        PluginServletFilter container = null;
        if (j != null) {
            container = PluginServletFilter.getInstance(j.getServletContext());
        }
        if (j == null || container == null) {
            LOGGER.log(Level.WARNING, "Filter instance is registered too early: " + filter, new Exception());
            LEGACY.add(filter);
        } else {
            filter.init(container.config);
            container.list.add(filter);
        }
    }

    @Deprecated
    public static void addFilter(javax.servlet.Filter filter) throws ServletException {
        try {
            PluginServletFilter.addFilter(FilterWrapper.toJakartaFilter((javax.servlet.Filter)filter));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    public static boolean hasFilter(Filter filter) {
        Jenkins j = Jenkins.getInstanceOrNull();
        PluginServletFilter container = null;
        if (j != null) {
            container = PluginServletFilter.getInstance(j.getServletContext());
        }
        if (j == null || container == null) {
            return LEGACY.contains(filter);
        }
        return container.list.contains(filter);
    }

    @Deprecated
    public static boolean hasFilter(javax.servlet.Filter filter) {
        return PluginServletFilter.hasFilter(FilterWrapper.toJakartaFilter((javax.servlet.Filter)filter));
    }

    public static void removeFilter(Filter filter) throws jakarta.servlet.ServletException {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j == null || PluginServletFilter.getInstance(j.getServletContext()) == null) {
            LEGACY.remove(filter);
        } else {
            PluginServletFilter.getInstance((ServletContext)j.getServletContext()).list.remove(filter);
        }
    }

    @Deprecated
    public static void removeFilter(javax.servlet.Filter filter) throws ServletException {
        try {
            PluginServletFilter.removeFilter(FilterWrapper.toJakartaFilter((javax.servlet.Filter)filter));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, final FilterChain chain) throws IOException, jakarta.servlet.ServletException {
        new FilterChain(){
            private final Iterator<Filter> itr;
            {
                this.itr = PluginServletFilter.this.list.iterator();
            }

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, jakarta.servlet.ServletException {
                if (this.itr.hasNext()) {
                    this.itr.next().doFilter(request, response, (FilterChain)this);
                } else {
                    chain.doFilter(request, response);
                }
            }
        }.doFilter(request, response);
    }

    public void destroy() {
        for (Filter f : this.list) {
            f.destroy();
        }
        this.list.clear();
    }

    @Restricted(value={NoExternalUse.class})
    public static void cleanUp() {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return;
        }
        PluginServletFilter instance = PluginServletFilter.getInstance(jenkins.getServletContext());
        if (instance != null) {
            for (Filter f : new ArrayList<Filter>(instance.list)) {
                instance.list.remove(f);
                try {
                    f.destroy();
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Filter " + f + " propagated an exception from its destroy method", e);
                }
                catch (Error e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOGGER.log(Level.SEVERE, "Filter " + f + " propagated an exception from its destroy method", e);
                }
            }
            if (!instance.list.isEmpty()) {
                LOGGER.log(Level.SEVERE, "The following filters appear to have been added during clean up: {0}", instance.list);
            }
        }
    }
}

