/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import java.util.List;
import java.util.concurrent.Future;
import jenkins.model.IDisplayExecutor;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public interface IComputer
extends AccessControlled {
    @NonNull
    public String getName();

    @NonNull
    public List<? extends IDisplayExecutor> getDisplayExecutors();

    public boolean isOffline();

    @NonNull
    public String getDisplayName();

    public boolean isAcceptingTasks();

    @NonNull
    public String getUrl();

    default public boolean hasOfflineCause() {
        return Util.fixEmpty(this.getOfflineCauseReason()) != null;
    }

    @NonNull
    public String getOfflineCauseReason();

    public boolean isConnecting();

    public String getIcon();

    public String getIconAltText();

    default public String getIconClassName() {
        return this.getIcon();
    }

    public int countBusy();

    public int countExecutors();

    public boolean isOnline();

    public int countIdle();

    public boolean isLaunchSupported();

    public Future<?> connect(boolean var1);

    @Override
    @NonNull
    default public ACL getACL() {
        return Jenkins.get().getAuthorizationStrategy().getACL(this);
    }
}

