/*
 * Decompiled with CFR 0.152.
 */
package jenkins.tasks;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Action;
import hudson.model.Actionable;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStep;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import jenkins.model.TransientActionFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public interface SimpleBuildStep
extends BuildStep {
    @Deprecated
    default public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        this.perform(run, workspace, run.getEnvironment(listener), launcher, listener);
    }

    default public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (!this.requiresWorkspace()) {
            this.perform(run, env, listener);
            return;
        }
        if (!Util.isOverridden(SimpleBuildStep.class, this.getClass(), "perform", Run.class, FilePath.class, Launcher.class, TaskListener.class)) {
            throw new AbstractMethodError("Unless a build step is marked as not requiring a workspace context, you must implement the overload of the perform() method that takes both a workspace and a launcher.");
        }
        this.perform(run, workspace, launcher, listener);
    }

    default public void perform(@NonNull Run<?, ?> run, @NonNull EnvVars env, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (this.requiresWorkspace()) {
            throw new IllegalStateException("This build step requires a workspace context, but none was provided.");
        }
        throw new AbstractMethodError("When a build step is marked as not requiring a workspace context, you must implement the overload of the perform() method that does not take a workspace or launcher.");
    }

    default public boolean requiresWorkspace() {
        return true;
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static final class LastBuildActionFactory
    extends TransientActionFactory<Job> {
        @Override
        public Class<Job> type() {
            return Job.class;
        }

        @Override
        @NonNull
        public Collection<? extends Action> createFor(@NonNull Job j) {
            ArrayList<? extends Action> actions = new ArrayList<Action>();
            Object r = j.getLastSuccessfulBuild();
            if (r != null) {
                for (LastBuildAction a : ((Actionable)r).getActions(LastBuildAction.class)) {
                    actions.addAll(a.getProjectActions());
                }
            }
            return actions;
        }
    }

    public static interface LastBuildAction
    extends Action {
        public Collection<? extends Action> getProjectActions();
    }
}

