/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.BulkChange;
import hudson.ExtensionList;
import hudson.PluginWrapper;
import hudson.RelativePath;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.DescriptorByNameOwner;
import hudson.model.Failure;
import hudson.model.Messages;
import hudson.model.Saveable;
import hudson.model.listeners.SaveableListener;
import hudson.security.Permission;
import hudson.util.FormApply;
import hudson.util.FormValidation;
import hudson.util.ReflectionUtils;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.beans.Introspector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import jenkins.model.Loadable;
import jenkins.security.RedactSecretJsonInErrorMessageSanitizer;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.io.OnMaster;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.BindInterceptor;
import org.kohsuke.stapler.Facet;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebApp;
import org.kohsuke.stapler.jelly.JellyCompatibleFacet;
import org.kohsuke.stapler.lang.Klass;

public abstract class Descriptor<T extends Describable<T>>
implements Loadable,
Saveable,
OnMaster {
    public final transient Class<? extends T> clazz;
    private final transient Map<String, FormValidation.CheckMethod> checkMethods = new ConcurrentHashMap<String, FormValidation.CheckMethod>(2);
    private volatile transient Map<String, PropertyType> propertyTypes;
    private volatile transient Map<String, PropertyType> globalPropertyTypes;
    private final transient Map<String, HelpRedirect> helpRedirect = new HashMap<String, HelpRedirect>(2);
    private static final Logger LOGGER = Logger.getLogger(Descriptor.class.getName());

    protected Descriptor(Class<? extends T> clazz) {
        if (clazz == Descriptor.self()) {
            clazz = this.getClass();
        }
        this.clazz = clazz;
    }

    protected Descriptor() {
        ParameterizedType pt;
        Class t;
        this.clazz = this.getClass().getEnclosingClass();
        if (this.clazz == null) {
            throw new AssertionError((Object)(this.getClass() + " doesn't have an outer class. Use the constructor that takes the Class object explicitly."));
        }
        Type bt = Types.getBaseClass(this.getClass(), Descriptor.class);
        if (bt instanceof ParameterizedType && !(t = Types.erasure((Type)(pt = (ParameterizedType)bt).getActualTypeArguments()[0])).isAssignableFrom(this.clazz)) {
            throw new AssertionError((Object)("Outer class " + this.clazz + " of " + this.getClass() + " is not assignable to " + t + ". Perhaps wrong outer class?"));
        }
        try {
            Method getd = this.clazz.getMethod("getDescriptor", new Class[0]);
            if (!getd.getReturnType().isAssignableFrom(this.getClass())) {
                throw new AssertionError((Object)(this.getClass() + " must be assignable to " + getd.getReturnType()));
            }
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError(this.getClass() + " is missing getDescriptor method.", e);
        }
    }

    @NonNull
    public String getDisplayName() {
        return this.clazz.getSimpleName();
    }

    public String getId() {
        return this.clazz.getName();
    }

    public Class<T> getT() {
        Type subTyping = Types.getBaseClass(this.getClass(), Descriptor.class);
        if (!(subTyping instanceof ParameterizedType)) {
            throw new IllegalStateException(this.getClass() + " doesn't extend Descriptor with a type parameter.");
        }
        return Types.erasure((Type)Types.getTypeArgument((Type)subTyping, (int)0));
    }

    public String getDescriptorUrl() {
        return "descriptorByName/" + this.getId();
    }

    public final String getDescriptorFullUrl() {
        return Descriptor.getCurrentDescriptorByNameUrl() + "/" + this.getDescriptorUrl();
    }

    public static String getCurrentDescriptorByNameUrl() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        Object url = req.getAttribute("currentDescriptorByNameUrl");
        if (url != null) {
            return url.toString();
        }
        Ancestor a = req.findAncestor(DescriptorByNameOwner.class);
        return a.getUrl();
    }

    @Deprecated
    public String getCheckUrl(String fieldName) {
        return this.getCheckMethod(fieldName).toCheckUrl();
    }

    public FormValidation.CheckMethod getCheckMethod(String fieldName) {
        FormValidation.CheckMethod method = this.checkMethods.get(fieldName);
        if (method == null) {
            method = new FormValidation.CheckMethod(this, fieldName);
            this.checkMethods.put(fieldName, method);
        }
        return method;
    }

    public void calcFillSettings(String field, Map<String, Object> attributes) {
        String capitalizedFieldName = field == null || field.isEmpty() ? field : Character.toTitleCase(field.charAt(0)) + field.substring(1);
        String methodName = "doFill" + capitalizedFieldName + "Items";
        Method method = ReflectionUtils.getPublicMethodNamed(this.getClass(), methodName);
        if (method == null) {
            throw new IllegalStateException(String.format("%s doesn't have the %s method for filling a drop-down list", this.getClass(), methodName));
        }
        List<String> depends = this.buildFillDependencies(method, new ArrayList<String>());
        if (!depends.isEmpty()) {
            attributes.put("fillDependsOn", String.join((CharSequence)" ", depends));
        }
        attributes.put("fillUrl", String.format("%s/%s/fill%sItems", Descriptor.getCurrentDescriptorByNameUrl(), this.getDescriptorUrl(), capitalizedFieldName));
    }

    private List<String> buildFillDependencies(Method method, List<String> depends) {
        for (ReflectionUtils.Parameter p : ReflectionUtils.getParameters(method)) {
            QueryParameter qp = p.annotation(QueryParameter.class);
            if (qp != null) {
                Object name = qp.value();
                if (((String)name).isEmpty()) {
                    name = p.name();
                }
                if (name == null || ((String)name).isEmpty()) continue;
                RelativePath rp = p.annotation(RelativePath.class);
                if (rp != null) {
                    name = rp.value() + "/" + (String)name;
                }
                depends.add((String)name);
                continue;
            }
            Method m = ReflectionUtils.getPublicMethodNamed(p.type(), "fromStapler");
            if (m == null) continue;
            this.buildFillDependencies(m, depends);
        }
        return depends;
    }

    public void calcAutoCompleteSettings(String field, Map<String, Object> attributes) {
        String capitalizedFieldName = field == null || field.isEmpty() ? field : Character.toTitleCase(field.charAt(0)) + field.substring(1);
        String methodName = "doAutoComplete" + capitalizedFieldName;
        Method method = ReflectionUtils.getPublicMethodNamed(this.getClass(), methodName);
        if (method == null) {
            return;
        }
        attributes.put("autoCompleteUrl", String.format("%s/%s/autoComplete%s", Descriptor.getCurrentDescriptorByNameUrl(), this.getDescriptorUrl(), capitalizedFieldName));
    }

    @CheckForNull
    public PropertyType getPropertyType(@NonNull Object instance, @NonNull String field) {
        return instance == this ? this.getGlobalPropertyType(field) : this.getPropertyType(field);
    }

    @NonNull
    public PropertyType getPropertyTypeOrDie(@NonNull Object instance, @NonNull String field) {
        PropertyType propertyType = this.getPropertyType(instance, field);
        if (propertyType != null) {
            return propertyType;
        }
        if (instance == this) {
            throw new AssertionError((Object)(this.getClass().getName() + " has no property " + field));
        }
        throw new AssertionError((Object)(this.clazz.getName() + " has no property " + field));
    }

    public PropertyType getPropertyType(String field) {
        if (this.propertyTypes == null) {
            this.propertyTypes = this.buildPropertyTypes(this.clazz);
        }
        return this.propertyTypes.get(field);
    }

    public PropertyType getGlobalPropertyType(String field) {
        if (this.globalPropertyTypes == null) {
            this.globalPropertyTypes = this.buildPropertyTypes(this.getClass());
        }
        return this.globalPropertyTypes.get(field);
    }

    private Map<String, PropertyType> buildPropertyTypes(Class<?> clazz) {
        HashMap<String, PropertyType> r = new HashMap<String, PropertyType>();
        for (Field field : clazz.getFields()) {
            r.put(field.getName(), new PropertyType(field));
        }
        for (AccessibleObject accessibleObject : clazz.getMethods()) {
            if (!((Method)accessibleObject).getName().startsWith("get")) continue;
            r.put(Introspector.decapitalize(((Method)accessibleObject).getName().substring(3)), new PropertyType((Method)accessibleObject));
        }
        return r;
    }

    public final String getJsonSafeClassName() {
        return this.getId().replace('.', '-');
    }

    @Deprecated
    public T newInstance(StaplerRequest req) throws FormException {
        throw new UnsupportedOperationException(this.getClass() + " should implement newInstance(StaplerRequest,JSONObject)");
    }

    public T newInstance(@Nullable StaplerRequest2 req, @NonNull JSONObject formData) throws FormException {
        if (Util.isOverridden(Descriptor.class, this.getClass(), "newInstance", StaplerRequest.class, JSONObject.class)) {
            return this.newInstance(req != null ? StaplerRequest.fromStaplerRequest2((StaplerRequest2)req) : null, formData);
        }
        return this.newInstanceImpl(req, formData);
    }

    @Deprecated
    public T newInstance(@Nullable StaplerRequest req, @NonNull JSONObject formData) throws FormException {
        return this.newInstanceImpl(req != null ? StaplerRequest.toStaplerRequest2((StaplerRequest)req) : null, formData);
    }

    private T newInstanceImpl(@Nullable StaplerRequest2 req, @NonNull JSONObject formData) throws FormException {
        try {
            Method m = this.getClass().getMethod("newInstance", StaplerRequest.class);
            if (!Modifier.isAbstract(m.getDeclaringClass().getModifiers())) {
                return this.verifyNewInstance(this.newInstance(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req)));
            }
            if (req == null) {
                return (T)this.verifyNewInstance((Describable)this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            return (T)this.verifyNewInstance((Describable)Descriptor.bindJSON(req, this.clazz, formData, true));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | RuntimeException | InvocationTargetException e) {
            if (e instanceof RuntimeException && e instanceof HttpResponse) {
                throw (RuntimeException)e;
            }
            throw new LinkageError("Failed to instantiate " + this.clazz + " from " + RedactSecretJsonInErrorMessageSanitizer.INSTANCE.sanitize(formData), e);
        }
    }

    public static <T> T bindJSON(StaplerRequest2 req, Class<T> type, JSONObject src) {
        return Descriptor.bindJSON(req, type, src, false);
    }

    @Deprecated
    public static <T> T bindJSON(StaplerRequest req, Class<T> type, JSONObject src) {
        return Descriptor.bindJSON(StaplerRequest.toStaplerRequest2((StaplerRequest)req), type, src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T bindJSON(StaplerRequest2 req, Class<T> type, JSONObject src, boolean fromNewInstance) {
        BindInterceptor oldInterceptor = req.getBindInterceptor();
        try {
            NewInstanceBindInterceptor interceptor;
            if (oldInterceptor instanceof NewInstanceBindInterceptor) {
                interceptor = (NewInstanceBindInterceptor)oldInterceptor;
            } else {
                interceptor = new NewInstanceBindInterceptor(oldInterceptor);
                req.setBindInterceptor((BindInterceptor)interceptor);
            }
            if (fromNewInstance) {
                interceptor.processed.put(src, true);
            }
            Object object = req.bindJSON(type, src);
            return (T)object;
        }
        finally {
            req.setBindInterceptor(oldInterceptor);
        }
    }

    private T verifyNewInstance(T t) {
        if (t != null && t.getDescriptor() != this) {
            LOGGER.warning("Father of " + t + " and its getDescriptor() points to two different instances. Probably misplaced @Extension. See http://hudson.361315.n4.nabble.com/Help-Hint-needed-Post-build-action-doesn-t-stay-activated-td2308833.html");
        }
        return t;
    }

    public Klass<?> getKlass() {
        return Klass.java(this.clazz);
    }

    public String getHelpFile() {
        return this.getHelpFile(null);
    }

    public String getHelpFile(String fieldName) {
        return this.getHelpFile(this.getKlass(), fieldName);
    }

    @SuppressFBWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"}, justification="no big deal")
    public String getHelpFile(Klass<?> clazz, String fieldName) {
        HelpRedirect r = this.helpRedirect.get(fieldName);
        if (r != null) {
            return r.resolve();
        }
        for (Klass c : clazz.getAncestors()) {
            Object suffix;
            String page = "/descriptor/" + this.getId() + "/help";
            if (fieldName == null) {
                suffix = "";
            } else {
                page = page + "/" + fieldName;
                suffix = "-" + fieldName;
            }
            try {
                if (Stapler.getCurrentRequest2().getView(c, "help" + (String)suffix) != null) {
                    return page;
                }
            }
            catch (IOException e) {
                throw new Error(e);
            }
            if (Descriptor.getStaticHelpUrl(Stapler.getCurrentRequest2(), c, (String)suffix) == null) continue;
            return page;
        }
        return null;
    }

    protected void addHelpFileRedirect(String fieldName, Class<? extends Describable> owner, String fieldNameToRedirectTo) {
        this.helpRedirect.put(fieldName, new HelpRedirect(owner, fieldNameToRedirectTo));
    }

    public final boolean isInstance(T instance) {
        return this.clazz.isInstance(instance);
    }

    public final boolean isSubTypeOf(Class type) {
        return type.isAssignableFrom(this.clazz);
    }

    @Deprecated
    public boolean configure(StaplerRequest req) throws FormException {
        return true;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws FormException {
        if (Util.isOverridden(Descriptor.class, this.getClass(), "configure", StaplerRequest.class, JSONObject.class)) {
            return this.configure(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), json);
        }
        return this.configure(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req));
    }

    @Deprecated
    public boolean configure(StaplerRequest req, JSONObject json) throws FormException {
        return this.configure(req);
    }

    public String getConfigPage() {
        return this.getViewPage(this.clazz, this.getPossibleViewNames("config"), "config.jelly");
    }

    public String getGlobalConfigPage() {
        return this.getViewPage(this.clazz, this.getPossibleViewNames("global"), null);
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Unclassified.class);
    }

    @NonNull
    public Permission getRequiredGlobalConfigPagePermission() {
        return Jenkins.ADMINISTER;
    }

    private String getViewPage(Class<?> clazz, String pageName, String defaultValue) {
        return this.getViewPage(clazz, Set.of(pageName), defaultValue);
    }

    private String getViewPage(Class<?> clazz, Collection<String> pageNames, String defaultValue) {
        while (clazz != Object.class && clazz != null) {
            for (String pageName : pageNames) {
                String name = clazz.getName().replace('.', '/').replace('$', '/') + "/" + pageName;
                if (clazz.getClassLoader().getResource(name) == null) continue;
                return "/" + name;
            }
            clazz = clazz.getSuperclass();
        }
        return defaultValue;
    }

    protected final String getViewPage(Class<?> clazz, String pageName) {
        return this.getViewPage(clazz, pageName, pageName);
    }

    protected List<String> getPossibleViewNames(String baseName) {
        ArrayList<String> names = new ArrayList<String>();
        for (Facet f : WebApp.get((ServletContext)Jenkins.get().getServletContext()).facets) {
            if (!(f instanceof JellyCompatibleFacet)) continue;
            JellyCompatibleFacet jcf = (JellyCompatibleFacet)f;
            for (String ext : jcf.getScriptExtensions()) {
                names.add(baseName + ext);
            }
        }
        return names;
    }

    @Override
    public synchronized void save() {
        if (BulkChange.contains(this)) {
            return;
        }
        try {
            this.getConfigFile().write(this);
            SaveableListener.fireOnChange(this, this.getConfigFile());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to save " + this.getConfigFile(), e);
        }
    }

    @Override
    public synchronized void load() {
        XmlFile file = this.getConfigFile();
        if (!file.exists()) {
            return;
        }
        try {
            file.unmarshal(this);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to load " + file, e);
        }
    }

    protected XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.get().getRootDir(), this.getId() + ".xml"));
    }

    protected PluginWrapper getPlugin() {
        return Jenkins.get().getPluginManager().whichPlugin(this.clazz);
    }

    public void doHelp(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (Util.isOverridden(Descriptor.class, this.getClass(), "doHelp", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.doHelp(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (javax.servlet.ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((javax.servlet.ServletException)e);
            }
        } else {
            this.doHelpImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doHelp(StaplerRequest req, StaplerResponse rsp) throws IOException, javax.servlet.ServletException {
        try {
            this.doHelpImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
        }
        catch (ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((ServletException)e);
        }
    }

    private void doHelpImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        String path = req.getRestOfPath();
        if (path.contains("..")) {
            throw new ServletException("Illegal path: " + path);
        }
        path = path.replace('/', '-');
        PluginWrapper pw = this.getPlugin();
        if (pw != null) {
            rsp.setHeader("X-Plugin-Short-Name", pw.getShortName());
            rsp.setHeader("X-Plugin-Long-Name", pw.getLongName());
            rsp.setHeader("X-Plugin-From", Messages.Descriptor_From(pw.getLongName().replace("Hudson", "Jenkins").replace("hudson", "jenkins"), pw.getUrl()));
        }
        for (Klass c = this.getKlass(); c != null; c = c.getSuperClass()) {
            RequestDispatcher rd = Stapler.getCurrentRequest2().getView(c, "help" + path);
            if (rd != null) {
                rd.forward((ServletRequest)req, (ServletResponse)rsp);
                return;
            }
            URL url = Descriptor.getStaticHelpUrl(Stapler.getCurrentRequest2(), c, path);
            if (url == null) continue;
            rsp.setContentType("text/html;charset=UTF-8");
            try (InputStream in = url.openStream();){
                String literal = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                rsp.getWriter().println(Util.replaceMacro(literal, Map.of("rootURL", req.getContextPath())));
            }
            return;
        }
        rsp.sendError(404);
    }

    @Restricted(value={NoExternalUse.class})
    public static URL getStaticHelpUrl(StaplerRequest2 req, Klass<?> c, String suffix) {
        String base = "help" + suffix;
        Enumeration locales = req.getLocales();
        while (locales.hasMoreElements()) {
            Locale locale = (Locale)locales.nextElement();
            URL url = c.getResource(base + "_" + locale.getLanguage() + "_" + locale.getCountry() + "_" + locale.getVariant() + ".html");
            if (url != null) {
                return url;
            }
            url = c.getResource(base + "_" + locale.getLanguage() + "_" + locale.getCountry() + ".html");
            if (url != null) {
                return url;
            }
            url = c.getResource(base + "_" + locale.getLanguage() + ".html");
            if (url != null) {
                return url;
            }
            if (!locale.getLanguage().equals("en") || (url = c.getResource(base + ".html")) == null) continue;
            return url;
        }
        return c.getResource(base + ".html");
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static URL getStaticHelpUrl(StaplerRequest req, Klass<?> c, String suffix) {
        return Descriptor.getStaticHelpUrl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), c, suffix);
    }

    public static <T> T[] toArray(T ... values) {
        return values;
    }

    public static <T> List<T> toList(T ... values) {
        return new ArrayList<T>(Arrays.asList(values));
    }

    public static <T extends Describable<T>> Map<Descriptor<T>, T> toMap(Iterable<T> describables) {
        LinkedHashMap m = new LinkedHashMap();
        for (Describable d : describables) {
            Descriptor descriptor;
            try {
                descriptor = d.getDescriptor();
            }
            catch (Throwable x) {
                LOGGER.log(Level.WARNING, null, x);
                continue;
            }
            m.put(descriptor, d);
        }
        return m;
    }

    public static <T extends Describable<T>> List<T> newInstancesFromHeteroList(StaplerRequest2 req, JSONObject formData, String key, Collection<? extends Descriptor<T>> descriptors) throws FormException {
        return Descriptor.newInstancesFromHeteroList(req, formData.get(key), descriptors);
    }

    @Deprecated
    public static <T extends Describable<T>> List<T> newInstancesFromHeteroList(StaplerRequest req, JSONObject formData, String key, Collection<? extends Descriptor<T>> descriptors) throws FormException {
        return Descriptor.newInstancesFromHeteroList(StaplerRequest.toStaplerRequest2((StaplerRequest)req), formData, key, descriptors);
    }

    public static <T extends Describable<T>> List<T> newInstancesFromHeteroList(StaplerRequest2 req, Object formData, Collection<? extends Descriptor<T>> descriptors) throws FormException {
        ArrayList<T> items = new ArrayList<T>();
        if (formData != null) {
            for (Object o : JSONArray.fromObject((Object)formData)) {
                JSONObject jo = (JSONObject)o;
                Descriptor<T> d = null;
                String kind = jo.optString("kind", null);
                if (kind != null) {
                    d = Descriptor.findById(descriptors, kind);
                }
                if (d == null && (kind = jo.optString("$class")) != null && (d = Descriptor.findByDescribableClassName(descriptors, kind)) == null) {
                    d = Descriptor.findByClassName(descriptors, kind);
                }
                if (d != null) {
                    items.add(d.newInstance(req, jo));
                    continue;
                }
                LOGGER.log(Level.WARNING, "Received unexpected form data element: {0}", jo);
            }
        }
        return items;
    }

    @Deprecated
    public static <T extends Describable<T>> List<T> newInstancesFromHeteroList(StaplerRequest req, Object formData, Collection<? extends Descriptor<T>> descriptors) throws FormException {
        return Descriptor.newInstancesFromHeteroList(StaplerRequest.toStaplerRequest2((StaplerRequest)req), formData, descriptors);
    }

    @CheckForNull
    public static <T extends Descriptor> T findById(Collection<? extends T> list, String id) {
        for (Descriptor d : list) {
            if (!d.getId().equals(id)) continue;
            return (T)d;
        }
        return null;
    }

    @CheckForNull
    private static <T extends Descriptor> T findByClassName(Collection<? extends T> list, String className) {
        for (Descriptor d : list) {
            if (!d.getClass().getName().equals(className)) continue;
            return (T)d;
        }
        return null;
    }

    @CheckForNull
    public static <T extends Descriptor> T findByDescribableClassName(Collection<? extends T> list, String className) {
        for (Descriptor d : list) {
            if (!d.clazz.getName().equals(className)) continue;
            return (T)d;
        }
        return null;
    }

    @Deprecated
    @CheckForNull
    public static <T extends Descriptor> T find(Collection<? extends T> list, String string) {
        T d = Descriptor.findByClassName(list, string);
        if (d != null) {
            return d;
        }
        return Descriptor.findById(list, string);
    }

    @Deprecated
    @CheckForNull
    public static Descriptor find(String className) {
        return Descriptor.find(ExtensionList.lookup(Descriptor.class), className);
    }

    protected static Class self() {
        return Self.class;
    }

    public static final class PropertyType {
        public final Class clazz;
        public final Type type;
        private volatile Class itemType;
        public final String displayName;

        PropertyType(Class clazz, Type type, String displayName) {
            this.clazz = clazz;
            this.type = type;
            this.displayName = displayName;
        }

        PropertyType(Field f) {
            this(f.getType(), f.getGenericType(), f.toString());
        }

        PropertyType(Method getter) {
            this(getter.getReturnType(), getter.getGenericReturnType(), getter.toString());
        }

        public Enum[] getEnumConstants() {
            return (Enum[])this.clazz.getEnumConstants();
        }

        public Class getItemType() {
            if (this.itemType == null) {
                this.itemType = this.computeItemType();
            }
            return this.itemType;
        }

        private Class computeItemType() {
            if (this.clazz.isArray()) {
                return this.clazz.getComponentType();
            }
            if (Collection.class.isAssignableFrom(this.clazz)) {
                Type col = Types.getBaseClass((Type)this.type, Collection.class);
                if (col instanceof ParameterizedType) {
                    return Types.erasure((Type)Types.getTypeArgument((Type)col, (int)0));
                }
                return Object.class;
            }
            return null;
        }

        public Descriptor getItemTypeDescriptor() {
            return Jenkins.get().getDescriptor(this.getItemType());
        }

        public Descriptor getItemTypeDescriptorOrDie() {
            Class it = this.getItemType();
            if (it == null) {
                throw new AssertionError((Object)(this.clazz + " is not an array/collection type in " + this.displayName + ". See https://www.jenkins.io/redirect/developer/class-is-missing-descriptor"));
            }
            Descriptor d = Jenkins.get().getDescriptor(it);
            if (d == null) {
                throw new AssertionError((Object)(it + " is missing its descriptor in " + this.displayName + ". See https://www.jenkins.io/redirect/developer/class-is-missing-descriptor"));
            }
            return d;
        }

        public List<? extends Descriptor> getApplicableDescriptors() {
            return Jenkins.get().getDescriptorList(this.clazz);
        }

        public List<? extends Descriptor> getApplicableItemDescriptors() {
            return Jenkins.get().getDescriptorList(this.getItemType());
        }
    }

    private static class NewInstanceBindInterceptor
    extends BindInterceptor {
        private final BindInterceptor oldInterceptor;
        private final IdentityHashMap<JSONObject, Boolean> processed = new IdentityHashMap();

        NewInstanceBindInterceptor(BindInterceptor oldInterceptor) {
            LOGGER.log(Level.FINER, "new interceptor delegating to {0}", oldInterceptor);
            this.oldInterceptor = oldInterceptor;
        }

        private boolean isApplicable(Class type, JSONObject json) {
            if (Modifier.isAbstract(type.getModifiers())) {
                LOGGER.log(Level.FINER, "ignoring abstract {0} {1}", new Object[]{type.getName(), json});
                return false;
            }
            if (!Describable.class.isAssignableFrom(type)) {
                LOGGER.log(Level.FINER, "ignoring non-Describable {0} {1}", new Object[]{type.getName(), json});
                return false;
            }
            if (Boolean.TRUE.equals(this.processed.put(json, true))) {
                LOGGER.log(Level.FINER, "already processed {0} {1}", new Object[]{type.getName(), json});
                return false;
            }
            return true;
        }

        public Object instantiate(Class actualType, JSONObject json) {
            if (this.isApplicable(actualType, json)) {
                LOGGER.log(Level.FINE, "switching to newInstance {0} {1}", new Object[]{actualType.getName(), json});
                try {
                    Descriptor descriptor = Jenkins.get().getDescriptor(actualType);
                    if (descriptor != null) {
                        return descriptor.newInstance(Stapler.getCurrentRequest2(), json);
                    }
                    LOGGER.log(Level.WARNING, "Descriptor not found. Falling back to default instantiation " + actualType.getName() + " " + json);
                }
                catch (Exception x) {
                    LOGGER.log(x instanceof HttpResponse ? Level.FINE : Level.WARNING, "falling back to default instantiation " + actualType.getName() + " " + json, x);
                }
            }
            return this.oldInterceptor.instantiate(actualType, json);
        }

        public Object onConvert(Type targetType, Class targetTypeErasure, Object jsonSource) {
            if (jsonSource instanceof JSONObject) {
                JSONObject json = (JSONObject)jsonSource;
                if (this.isApplicable(targetTypeErasure, json)) {
                    LOGGER.log(Level.FINE, "switching to newInstance {0} {1}", new Object[]{targetTypeErasure.getName(), json});
                    try {
                        return Jenkins.get().getDescriptor(targetTypeErasure).newInstance(Stapler.getCurrentRequest2(), json);
                    }
                    catch (Exception x) {
                        LOGGER.log(Level.WARNING, "falling back to default instantiation " + targetTypeErasure.getName() + " " + json, x);
                    }
                }
            } else {
                LOGGER.log(Level.FINER, "ignoring non-object {0}", jsonSource);
            }
            return this.oldInterceptor.onConvert(targetType, targetTypeErasure, jsonSource);
        }
    }

    private static class HelpRedirect {
        private final Class<? extends Describable> owner;
        private final String fieldNameToRedirectTo;

        private HelpRedirect(Class<? extends Describable> owner, String fieldNameToRedirectTo) {
            this.owner = owner;
            this.fieldNameToRedirectTo = fieldNameToRedirectTo;
        }

        private String resolve() {
            return Jenkins.get().getDescriptor(this.owner).getHelpFile(this.fieldNameToRedirectTo);
        }
    }

    public static final class Self {
    }

    public static final class FormException
    extends Exception
    implements HttpResponse {
        private final String formField;

        public FormException(String message, String formField) {
            super(message);
            this.formField = formField;
        }

        public FormException(String message, Throwable cause, String formField) {
            super(message, cause);
            this.formField = formField;
        }

        public FormException(Throwable cause, String formField) {
            super(cause);
            this.formField = formField;
        }

        public String getFormField() {
            return this.formField;
        }

        public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
            if (FormApply.isApply(req)) {
                FormApply.showNotification(this.getMessage(), FormApply.NotificationType.ERROR).generateResponse(req, rsp, node);
            } else {
                new Failure(this.getMessage()).generateResponse(req, rsp, node, this.getCause());
            }
        }
    }
}

