/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Descriptor;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.userproperty.UserPropertyCategory;
import java.util.Optional;
import org.jenkinsci.Symbol;

public abstract class UserPropertyDescriptor
extends Descriptor<UserProperty> {
    protected UserPropertyDescriptor(Class<? extends UserProperty> clazz) {
        super(clazz);
    }

    protected UserPropertyDescriptor() {
    }

    public abstract UserProperty newInstance(User var1);

    public boolean isEnabled() {
        return true;
    }

    @NonNull
    public UserPropertyCategory getUserPropertyCategory() {
        Optional<UserPropertyCategory> firstIfFound;
        String categoryAsString = this.getUserPropertyCategoryAsString();
        if (categoryAsString != null && (firstIfFound = UserPropertyCategory.all().stream().filter(cat -> {
            Symbol symbolAnnotation = cat.getClass().getAnnotation(Symbol.class);
            if (symbolAnnotation != null) {
                for (String symbolValue : symbolAnnotation.value()) {
                    if (!symbolValue.equalsIgnoreCase(categoryAsString)) continue;
                    return true;
                }
            }
            return false;
        }).findFirst()).isPresent()) {
            return firstIfFound.get();
        }
        return UserPropertyCategory.get(UserPropertyCategory.Unclassified.class);
    }

    @Deprecated
    @CheckForNull
    protected String getUserPropertyCategoryAsString() {
        return null;
    }

    @Nullable
    public String getDescription() {
        return null;
    }
}

