/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.userproperty;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.TransientUserActionFactory;
import hudson.model.User;
import hudson.model.UserProperty;
import hudson.model.UserPropertyDescriptor;
import hudson.model.userproperty.Messages;
import hudson.model.userproperty.UserPropertyCategory;
import hudson.model.userproperty.UserPropertyCategoryAction;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.security.UserDetailsCache;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.verb.POST;

@Restricted(value={NoExternalUse.class})
public class UserPropertyCategoryAccountAction
extends UserPropertyCategoryAction
implements Action {
    public UserPropertyCategoryAccountAction(@NonNull User user) {
        super(user);
    }

    @Override
    public String getDisplayName() {
        return Messages.UserPropertyCategoryAccountAction_DisplayName();
    }

    @Override
    public String getIconFileName() {
        return this.getTargetUser().hasPermission(Jenkins.ADMINISTER) ? "symbol-settings" : null;
    }

    @Override
    public String getUrlName() {
        return "account";
    }

    @Override
    @NonNull
    public List<UserPropertyDescriptor> getMyCategoryDescriptors() {
        return UserPropertyCategoryAccountAction.allByTwoCategoryClasses(UserPropertyCategory.Unclassified.class, UserPropertyCategory.Account.class);
    }

    private static List<UserPropertyDescriptor> allByTwoCategoryClasses(@NonNull Class<? extends UserPropertyCategory> categoryClass1, @NonNull Class<? extends UserPropertyCategory> categoryClass2) {
        DescriptorExtensionList all = UserProperty.all();
        ArrayList<UserPropertyDescriptor> filteredList = new ArrayList<UserPropertyDescriptor>(all.size());
        for (UserPropertyDescriptor descriptor : all) {
            Class<?> currClass = descriptor.getUserPropertyCategory().getClass();
            if (!currClass.equals(categoryClass1) && !currClass.equals(categoryClass2)) continue;
            filteredList.add(descriptor);
        }
        return filteredList;
    }

    @Override
    @POST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException, Descriptor.FormException {
        User targetUser = this.getTargetUser();
        targetUser.checkPermission(Jenkins.ADMINISTER);
        JSONObject json = req.getSubmittedForm();
        String oldFullName = targetUser.getFullName();
        targetUser.setFullName(json.getString("fullName"));
        targetUser.setDescription(json.getString("description"));
        super.doConfigSubmit(req, rsp);
        if (!oldFullName.equals(targetUser.getFullName())) {
            UserDetailsCache.get().invalidate(oldFullName);
        }
    }

    @Extension(ordinal=400.0)
    @Symbol(value={"account"})
    public static class AccountActionFactory
    extends TransientUserActionFactory {
        @Override
        public Collection<? extends Action> createFor(User target) {
            return Collections.singleton(new UserPropertyCategoryAccountAction(target));
        }
    }
}

