/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.core.util.SerializationMembers;
import com.thoughtworks.xstream.io.ExtendedHierarchicalStreamWriterHelper;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.security.InputManipulationException;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.Saveable;
import hudson.security.ACL;
import hudson.util.RobustCollectionConverter;
import hudson.util.RobustMapConverter;
import hudson.util.XStream2;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.util.SystemProperties;
import jenkins.util.xstream.CriticalXStreamException;
import net.jcip.annotations.GuardedBy;
import org.acegisecurity.Authentication;
import org.jvnet.tiger_types.Types;

public class RobustReflectionConverter
implements Converter {
    static boolean RECORD_FAILURES_FOR_ALL_AUTHENTICATIONS = SystemProperties.getBoolean(RobustReflectionConverter.class.getName() + ".recordFailuresForAllAuthentications", false);
    private static boolean RECORD_FAILURES_FOR_ADMINS = SystemProperties.getBoolean(RobustReflectionConverter.class.getName() + ".recordFailuresForAdmins", false);
    protected final ReflectionProvider reflectionProvider;
    protected final Mapper mapper;
    protected transient SerializationMembers serializationMethodInvoker;
    private transient ReflectionProvider pureJavaReflectionProvider;
    @NonNull
    private final XStream2.ClassOwnership classOwnership;
    private final ReadWriteLock criticalFieldsLock = new ReentrantReadWriteLock();
    @GuardedBy(value="criticalFieldsLock")
    private final Map<String, Set<String>> criticalFields = new HashMap<String, Set<String>>();
    private static final Logger LOGGER = Logger.getLogger(RobustReflectionConverter.class.getName());

    public RobustReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider) {
        this(mapper, reflectionProvider, new XStream2.PluginClassOwnership(new XStream2()));
    }

    RobustReflectionConverter(Mapper mapper, ReflectionProvider reflectionProvider, XStream2.ClassOwnership classOwnership) {
        this.mapper = mapper;
        this.reflectionProvider = reflectionProvider;
        assert (classOwnership != null);
        this.classOwnership = classOwnership;
        this.serializationMethodInvoker = new SerializationMembers();
    }

    void addCriticalField(Class<?> clazz, String field) {
        this.criticalFieldsLock.writeLock().lock();
        try {
            if (!this.criticalFields.containsKey(field)) {
                this.criticalFields.put(field, new HashSet());
            }
            this.criticalFields.get(field).add(clazz.getName());
        }
        finally {
            this.criticalFieldsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasCriticalField(Class<?> clazz, String field) {
        this.criticalFieldsLock.readLock().lock();
        try {
            Set<String> classesWithField = this.criticalFields.get(field);
            if (classesWithField == null) {
                boolean bl = false;
                return bl;
            }
            if (!classesWithField.contains(clazz.getName())) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.criticalFieldsLock.readLock().unlock();
        }
    }

    public boolean canConvert(Class type) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Object original, HierarchicalStreamWriter writer, MarshallingContext context) {
        Object source = this.serializationMethodInvoker.callWriteReplace(original);
        if (source.getClass() != original.getClass()) {
            writer.addAttribute(this.mapper.aliasForAttribute("resolves-to"), this.mapper.serializedClass(source.getClass()));
        }
        OwnerContext oc = OwnerContext.find(context);
        oc.startVisiting(writer, this.classOwnership.ownerOf(original.getClass()));
        try {
            this.doMarshal(source, writer, context);
        }
        finally {
            oc.stopVisiting();
        }
    }

    protected void doMarshal(final Object source, final HierarchicalStreamWriter writer, final MarshallingContext context) {
        final HashSet seenFields = new HashSet();
        final HashSet seenAsAttributes = new HashSet();
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class type, Class definedIn, Object value) {
                SingleValueConverter converter = RobustReflectionConverter.this.mapper.getConverterFromItemType(fieldName, type, definedIn);
                if (converter == null) {
                    converter = RobustReflectionConverter.this.mapper.getConverterFromItemType(fieldName, type);
                }
                if (converter == null) {
                    converter = RobustReflectionConverter.this.mapper.getConverterFromItemType(type);
                }
                if (converter != null) {
                    String str;
                    if (value != null && (str = converter.toString(value)) != null) {
                        writer.addAttribute(RobustReflectionConverter.this.mapper.aliasForAttribute(fieldName), str);
                    }
                    seenAsAttributes.add(fieldName);
                }
            }
        });
        this.reflectionProvider.visitSerializableFields(source, new ReflectionProvider.Visitor(){

            public void visit(String fieldName, Class fieldType, Class definedIn, Object newObj) {
                if (!seenAsAttributes.contains(fieldName) && newObj != null) {
                    Mapper.ImplicitCollectionMapping mapping = RobustReflectionConverter.this.mapper.getImplicitCollectionDefForFieldName(source.getClass(), fieldName);
                    if (mapping != null) {
                        if (mapping.getItemFieldName() != null) {
                            Collection list = (Collection)newObj;
                            for (Object obj : list) {
                                this.writeField(fieldName, mapping.getItemFieldName(), mapping.getItemType(), definedIn, obj);
                            }
                        } else {
                            context.convertAnother(newObj);
                        }
                    } else {
                        this.writeField(fieldName, fieldName, fieldType, definedIn, newObj);
                        seenFields.add(fieldName);
                    }
                }
            }

            private void writeField(String fieldName, String aliasName, Class fieldType, Class definedIn, Object newObj) {
                try {
                    String serializedClassName;
                    if (!RobustReflectionConverter.this.mapper.shouldSerializeMember(definedIn, aliasName)) {
                        return;
                    }
                    ExtendedHierarchicalStreamWriterHelper.startNode((HierarchicalStreamWriter)writer, (String)RobustReflectionConverter.this.mapper.serializedMember(definedIn, aliasName), (Class)fieldType);
                    Class<?> actualType = newObj.getClass();
                    Class defaultType = RobustReflectionConverter.this.mapper.defaultImplementationOf(fieldType);
                    if (!actualType.equals(defaultType) && !(serializedClassName = RobustReflectionConverter.this.mapper.serializedClass(actualType)).equals(RobustReflectionConverter.this.mapper.serializedClass(defaultType))) {
                        writer.addAttribute(RobustReflectionConverter.this.mapper.aliasForSystemAttribute("class"), serializedClassName);
                    }
                    if (seenFields.contains(aliasName)) {
                        writer.addAttribute(RobustReflectionConverter.this.mapper.aliasForAttribute("defined-in"), RobustReflectionConverter.this.mapper.serializedClass(definedIn));
                    }
                    Field field = RobustReflectionConverter.this.reflectionProvider.getField(definedIn, fieldName);
                    RobustReflectionConverter.this.marshallField(context, newObj, field);
                    writer.endNode();
                }
                catch (RuntimeException e) {
                    throw new RuntimeException("Failed to serialize " + definedIn.getName() + "#" + fieldName + " for " + source.getClass(), e);
                }
            }
        });
    }

    protected void marshallField(MarshallingContext context, Object newObj, Field field) {
        Converter converter = this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName());
        context.convertAnother(newObj, converter);
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = this.instantiateNewInstance(reader, context);
        result = this.doUnmarshal(result, reader, context);
        return this.serializationMethodInvoker.callReadResolve(result);
    }

    public Object doUnmarshal(Object result, HierarchicalStreamReader reader, UnmarshallingContext context) {
        SeenFields seenFields = new SeenFields();
        Iterator it = reader.getAttributeNames();
        if (result instanceof Saveable && context.get((Object)"Saveable") == null) {
            context.put((Object)"Saveable", result);
        }
        while (it.hasNext()) {
            String attrAlias = (String)it.next();
            String attrName = this.mapper.attributeForAlias(attrAlias);
            Class classDefiningField = this.determineWhichClassDefinesField(reader);
            boolean fieldExistsInClass = this.fieldDefinedInClass(result, attrName);
            if (!fieldExistsInClass) continue;
            Field field = this.reflectionProvider.getField(result.getClass(), attrName);
            SingleValueConverter converter = this.mapper.getConverterFromAttribute(field.getDeclaringClass(), attrName, field.getType());
            Class type = field.getType();
            if (converter == null) {
                converter = this.mapper.getConverterFromItemType(type);
            }
            if (converter == null) continue;
            Object value = converter.fromString(reader.getAttribute(attrAlias));
            if (type.isPrimitive()) {
                type = Primitives.box(type);
            }
            if (value != null && !type.isAssignableFrom(value.getClass())) {
                throw new ConversionException("Cannot convert type " + value.getClass().getName() + " to type " + type.getName());
            }
            this.reflectionProvider.writeField(result, attrName, value, classDefiningField);
            seenFields.add(classDefiningField, attrName);
        }
        HashMap<String, Collection<Object>> implicitCollectionsForCurrentObject = new HashMap<String, Collection<Object>>();
        HashMap implicitCollectionElementTypesForCurrentObject = new HashMap();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            boolean critical = false;
            try {
                Object value;
                String fieldName = this.mapper.realMember(result.getClass(), reader.getNodeName());
                for (Class<?> concrete = result.getClass(); concrete != null; concrete = concrete.getSuperclass()) {
                    if (!this.hasCriticalField(concrete, fieldName)) continue;
                    critical = true;
                    break;
                }
                boolean implicitCollectionHasSameName = this.mapper.getImplicitCollectionDefForFieldName(result.getClass(), reader.getNodeName()) != null;
                Class classDefiningField = this.determineWhichClassDefinesField(reader);
                boolean fieldExistsInClass = !implicitCollectionHasSameName && this.fieldDefinedInClass(result, fieldName);
                Class type = this.determineType(reader, fieldExistsInClass, result, fieldName, classDefiningField);
                if (fieldExistsInClass) {
                    Field field = this.reflectionProvider.getField(result.getClass(), fieldName);
                    value = this.unmarshalField(context, result, type, field);
                    Class definedType = this.reflectionProvider.getFieldType(result, fieldName, classDefiningField);
                    if (!definedType.isPrimitive()) {
                        type = definedType;
                    }
                } else {
                    value = context.convertAnother(result, type);
                }
                if (value != null && !type.isAssignableFrom(value.getClass())) {
                    LOGGER.warning("Cannot convert type " + value.getClass().getName() + " to type " + type.getName());
                } else if (fieldExistsInClass) {
                    this.reflectionProvider.writeField(result, fieldName, value, classDefiningField);
                    seenFields.add(classDefiningField, fieldName);
                } else {
                    this.writeValueToImplicitCollection(reader, context, value, implicitCollectionsForCurrentObject, implicitCollectionElementTypesForCurrentObject, result, fieldName);
                }
            }
            catch (CriticalXStreamException e) {
                throw e;
            }
            catch (InputManipulationException e) {
                LOGGER.warning("DoS detected and prevented. If the heuristic was too aggressive, you can customize the behavior by setting the hudson.util.XStream2.collectionUpdateLimit system property. See https://www.jenkins.io/redirect/xstream-dos-prevention for more information.");
                throw new CriticalXStreamException((XStreamException)((Object)e));
            }
            catch (XStreamException e) {
                if (critical) {
                    throw new CriticalXStreamException(e);
                }
                RobustReflectionConverter.addErrorInContext(context, e);
            }
            catch (LinkageError e) {
                if (critical) {
                    throw e;
                }
                RobustReflectionConverter.addErrorInContext(context, e);
            }
            reader.moveUp();
        }
        if (RobustReflectionConverter.shouldReportUnloadableDataForCurrentUser() && context.get((Object)"ReadError") != null && context.get((Object)"Saveable") == result) {
            try {
                OldDataMonitor.report((Saveable)result, (ArrayList)context.get((Object)"ReadError"));
            }
            catch (Throwable t) {
                StringBuilder message = new StringBuilder("There was a problem reporting unmarshalling field errors");
                Level level = Level.WARNING;
                if (t instanceof IllegalStateException && t.getMessage().contains("Expected 1 instance of " + OldDataMonitor.class.getName())) {
                    message.append(". Make sure this code is executed after InitMilestone.EXTENSIONS_AUGMENTED stage, for example in Plugin#postInitialize instead of Plugin#start");
                    level = Level.INFO;
                }
                LOGGER.log(level, message.toString(), t);
            }
            context.put((Object)"ReadError", null);
        }
        return result;
    }

    private static boolean shouldReportUnloadableDataForCurrentUser() {
        if (RECORD_FAILURES_FOR_ALL_AUTHENTICATIONS) {
            return true;
        }
        Authentication authentication = Jenkins.getAuthentication();
        if (authentication.equals(ACL.SYSTEM)) {
            return true;
        }
        return RECORD_FAILURES_FOR_ADMINS && Jenkins.get().hasPermission(Jenkins.ADMINISTER);
    }

    public static void addErrorInContext(UnmarshallingContext context, Throwable e) {
        LOGGER.log(Level.FINE, "Failed to load", e);
        ArrayList<Throwable> list = (ArrayList<Throwable>)context.get((Object)"ReadError");
        if (list == null) {
            list = new ArrayList<Throwable>();
            context.put((Object)"ReadError", list);
        }
        list.add(e);
    }

    private boolean fieldDefinedInClass(Object result, String attrName) {
        return this.reflectionProvider.getFieldOrNull(result.getClass(), attrName) != null;
    }

    protected Object unmarshalField(UnmarshallingContext context, Object result, Class type, Field field) {
        Object converter = this.mapper.getLocalConverter(field.getDeclaringClass(), field.getName());
        if (converter == null) {
            if (new RobustCollectionConverter(this.mapper, this.reflectionProvider).canConvert(type)) {
                converter = new RobustCollectionConverter(this.mapper, this.reflectionProvider, field.getGenericType());
            } else if (new RobustMapConverter(this.mapper).canConvert(type)) {
                converter = new RobustMapConverter(this.mapper, field.getGenericType());
            }
        }
        return context.convertAnother(result, type, converter);
    }

    private void writeValueToImplicitCollection(HierarchicalStreamReader reader, UnmarshallingContext context, Object value, Map<String, Collection<Object>> implicitCollections, Map<String, Class<?>> implicitCollectionElementTypes, Object result, String itemFieldName) {
        String fieldName = this.mapper.getFieldNameForItemTypeAndName(context.getRequiredType(), value.getClass(), itemFieldName);
        if (fieldName != null) {
            Class<Object> elementType;
            Collection collection = implicitCollections.get(fieldName);
            if (collection == null) {
                Field field = this.reflectionProvider.getField(result.getClass(), fieldName);
                Class fieldType = this.mapper.defaultImplementationOf(field.getType());
                if (!Collection.class.isAssignableFrom(fieldType)) {
                    throw new ObjectAccessException("Field " + fieldName + " of " + result.getClass().getName() + " is configured for an implicit Collection, but field is of type " + fieldType.getName());
                }
                if (this.pureJavaReflectionProvider == null) {
                    this.pureJavaReflectionProvider = new PureJavaReflectionProvider();
                }
                collection = (Collection)this.pureJavaReflectionProvider.newInstance(fieldType);
                this.reflectionProvider.writeField(result, fieldName, (Object)collection, null);
                implicitCollections.put(fieldName, collection);
                Type fieldGenericType = field.getGenericType();
                Type elementGenericType = Types.getTypeArgument((Type)Types.getBaseClass((Type)fieldGenericType, Collection.class), (int)0, Object.class);
                Class elementType2 = Types.erasure((Type)elementGenericType);
                implicitCollectionElementTypes.put(fieldName, elementType2);
            }
            if (!(elementType = implicitCollectionElementTypes.getOrDefault(fieldName, Object.class)).isInstance(value)) {
                ConversionException exception = new ConversionException("Invalid element type for implicit collection for field: " + fieldName);
                exception.add("required-type", elementType.getName());
                exception.add("class", value.getClass().getName());
                exception.add("converter-type", this.getClass().getName());
                reader.appendErrors((ErrorWriter)exception);
                throw exception;
            }
            collection.add((Object)value);
        }
    }

    private Class determineWhichClassDefinesField(HierarchicalStreamReader reader) {
        String definedIn = reader.getAttribute(this.mapper.aliasForAttribute("defined-in"));
        return definedIn == null ? null : this.mapper.realClass(definedIn);
    }

    protected Object instantiateNewInstance(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String readResolveValue = reader.getAttribute(this.mapper.aliasForAttribute("resolves-to"));
        Class type = readResolveValue != null ? this.mapper.realClass(readResolveValue) : context.getRequiredType();
        Object currentObject = context.currentObject();
        if (currentObject != null && type.isInstance(currentObject)) {
            return currentObject;
        }
        return this.reflectionProvider.newInstance(type);
    }

    private Class determineType(HierarchicalStreamReader reader, boolean validField, Object result, String fieldName, Class definedInCls) {
        String classAttribute = reader.getAttribute(this.mapper.aliasForAttribute("class"));
        if (classAttribute != null) {
            Class specifiedType = this.mapper.realClass(classAttribute);
            Class fieldType = this.reflectionProvider.getFieldType(result, fieldName, definedInCls);
            if (fieldType.isAssignableFrom(specifiedType)) {
                return specifiedType;
            }
        }
        if (!validField) {
            Class itemType = this.mapper.getItemTypeForItemFieldName(result.getClass(), fieldName);
            if (itemType != null) {
                return itemType;
            }
            return this.mapper.realClass(reader.getNodeName());
        }
        Class fieldType = this.reflectionProvider.getFieldType(result, fieldName, definedInCls);
        return this.mapper.defaultImplementationOf(fieldType);
    }

    private Object readResolve() {
        this.serializationMethodInvoker = new SerializationMembers();
        return this;
    }

    private static class OwnerContext
    extends LinkedList<String> {
        private OwnerContext() {
        }

        static OwnerContext find(MarshallingContext context) {
            OwnerContext c = (OwnerContext)context.get(OwnerContext.class);
            if (c == null) {
                c = new OwnerContext();
                context.put(OwnerContext.class, (Object)c);
            }
            return c;
        }

        private void startVisiting(HierarchicalStreamWriter writer, String owner) {
            if (owner != null) {
                boolean redundant = false;
                for (String parentOwner : this) {
                    if (parentOwner == null) continue;
                    redundant = parentOwner.equals(owner);
                    break;
                }
                if (!redundant) {
                    writer.addAttribute("plugin", owner);
                }
            }
            this.addFirst(owner);
        }

        private void stopVisiting() {
            this.removeFirst();
        }
    }

    private static class SeenFields {
        private Set seen = new HashSet();

        private SeenFields() {
        }

        public void add(Class definedInCls, String fieldName) {
            Object uniqueKey = fieldName;
            if (definedInCls != null) {
                uniqueKey = (String)uniqueKey + " [" + definedInCls.getName() + "]";
            }
            if (this.seen.contains(uniqueKey)) {
                throw new DuplicateFieldException((String)uniqueKey);
            }
            this.seen.add(uniqueKey);
        }
    }

    public static class DuplicateFieldException
    extends ConversionException {
        public DuplicateFieldException(String msg) {
            super(msg);
            this.add("duplicate-field", msg);
        }
    }
}

