/*
 * Decompiled with CFR 0.152.
 */
package jenkins.widgets;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.ComputerSet;
import hudson.model.View;
import hudson.widgets.Widget;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.model.queue.QueueItem;
import jenkins.widgets.WidgetFactory;
import org.jenkinsci.Symbol;

public class BuildQueueWidget
extends Widget {
    @NonNull
    private String ownerUrl;
    @NonNull
    private List<QueueItem> queueItems;
    private boolean filtered;

    public BuildQueueWidget(@NonNull String ownerUrl, @NonNull List<QueueItem> queueItems) {
        this(ownerUrl, queueItems, false);
    }

    public BuildQueueWidget(@NonNull String ownerUrl, @NonNull List<QueueItem> queueItems, boolean filtered) {
        this.ownerUrl = ownerUrl;
        this.queueItems = new ArrayList<QueueItem>(queueItems);
        this.filtered = filtered;
    }

    @Override
    public String getOwnerUrl() {
        return this.ownerUrl;
    }

    @NonNull
    public List<QueueItem> getQueueItems() {
        return this.queueItems;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    @Extension(ordinal=200.0)
    @Symbol(value={"buildQueueComputer"})
    public static final class ComputerSetFactoryImpl
    extends WidgetFactory<ComputerSet, BuildQueueWidget> {
        @Override
        public Class<ComputerSet> type() {
            return ComputerSet.class;
        }

        @Override
        public Class<BuildQueueWidget> widgetType() {
            return BuildQueueWidget.class;
        }

        @Override
        @NonNull
        public Collection<BuildQueueWidget> createFor(@NonNull ComputerSet target) {
            return List.of(new BuildQueueWidget("computer/", List.of(Jenkins.get().getQueue().getItems())));
        }
    }

    @Extension(ordinal=200.0)
    @Symbol(value={"buildQueueView"})
    public static final class ViewFactoryImpl
    extends WidgetFactory<View, BuildQueueWidget> {
        @Override
        public Class<View> type() {
            return View.class;
        }

        @Override
        public Class<BuildQueueWidget> widgetType() {
            return BuildQueueWidget.class;
        }

        @Override
        @NonNull
        public Collection<BuildQueueWidget> createFor(@NonNull View target) {
            return List.of(new BuildQueueWidget(target.getUrl(), new ArrayList<QueueItem>(target.getQueueItems()), target.isFilterQueue()));
        }
    }
}

