/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.security.AccessDeniedException2;
import hudson.security.Messages;
import hudson.security.Permission;
import io.jenkins.servlet.http.HttpServletResponseWrapper;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import jenkins.util.SystemProperties;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class AccessDeniedException3
extends AccessDeniedException {
    private static boolean REPORT_GROUP_HEADERS = SystemProperties.getBoolean(AccessDeniedException2.class.getName() + ".REPORT_GROUP_HEADERS");
    public final Authentication authentication;
    public final Permission permission;

    public AccessDeniedException3(Authentication authentication, Permission permission) {
        this(null, authentication, permission);
    }

    public AccessDeniedException3(Throwable t, Authentication authentication, Permission permission) {
        super(Messages.AccessDeniedException2_MissingPermission(authentication.getName(), String.valueOf(permission.group.title) + "/" + permission.name), t);
        this.authentication = authentication;
        this.permission = permission;
    }

    public void reportAsHeaders(jakarta.servlet.http.HttpServletResponse rsp) {
        this.reportAsHeadersImpl(rsp);
    }

    @Deprecated
    public void reportAsHeaders(HttpServletResponse rsp) {
        this.reportAsHeadersImpl(HttpServletResponseWrapper.toJakartaHttpServletResponse((HttpServletResponse)rsp));
    }

    private void reportAsHeadersImpl(jakarta.servlet.http.HttpServletResponse rsp) {
        rsp.addHeader("X-You-Are-Authenticated-As", this.authentication.getName());
        if (REPORT_GROUP_HEADERS) {
            for (GrantedAuthority auth : this.authentication.getAuthorities()) {
                rsp.addHeader("X-You-Are-In-Group", auth.getAuthority());
            }
        } else {
            rsp.addHeader("X-You-Are-In-Group-Disabled", "JENKINS-39402: use -Dhudson.security.AccessDeniedException2.REPORT_GROUP_HEADERS=true or use /whoAmI to diagnose");
        }
        rsp.addHeader("X-Required-Permission", this.permission.getId());
        Permission p = this.permission.impliedBy;
        while (p != null) {
            rsp.addHeader("X-Permission-Implied-By", p.getId());
            p = p.impliedBy;
        }
    }

    @SuppressFBWarnings(value={"XSS_SERVLET"}, justification="TODO needs triage")
    public void report(PrintWriter w) {
        w.println("You are authenticated as: " + this.authentication.getName());
        w.println("Groups that you are in:");
        for (GrantedAuthority auth : this.authentication.getAuthorities()) {
            w.println("  " + auth.getAuthority());
        }
        w.println("Permission you need to have (but didn't): " + this.permission.getId());
        Permission p = this.permission.impliedBy;
        while (p != null) {
            w.println(" ... which is implied by: " + p.getId());
            p = p.impliedBy;
        }
    }
}

