/*
 * Decompiled with CFR 0.152.
 */
package hudson.security;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.security.ACL;
import hudson.security.Permission;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.acegisecurity.acls.sid.GrantedAuthoritySid;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public abstract class SidACL
extends ACL {
    private static final Logger LOGGER = Logger.getLogger(SidACL.class.getName());

    @Override
    public boolean hasPermission2(@NonNull Authentication a, Permission permission) {
        if (a.equals(SYSTEM2)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("hasPermission(" + String.valueOf(a) + "," + String.valueOf(permission) + ")=>SYSTEM user has full access");
            }
            return true;
        }
        Boolean b = this._hasPermission(a, permission);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("hasPermission(" + String.valueOf(a) + "," + String.valueOf(permission) + ")=>" + String.valueOf(b == null ? "null, thus false" : b));
        }
        if (b == null) {
            b = false;
        }
        return b;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="converting this to YesNoMaybe would break backward compatibility")
    protected Boolean _hasPermission(@NonNull Authentication a, Permission permission) {
        Boolean b = this.hasPermission(new PrincipalSid(a), permission);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("hasPermission(PrincipalSID:" + String.valueOf(a.getPrincipal()) + "," + String.valueOf(permission) + ")=>" + b);
        }
        if (b != null) {
            return b;
        }
        for (GrantedAuthority ga : a.getAuthorities()) {
            b = this.hasPermission(new GrantedAuthoritySid(ga), permission);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("hasPermission(GroupSID:" + ga.getAuthority() + "," + String.valueOf(permission) + ")=>" + b);
            }
            if (b == null) continue;
            return b;
        }
        for (Sid sid : AUTOMATIC_SIDS) {
            b = this.hasPermission(sid, permission);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("hasPermission(" + String.valueOf(sid) + "," + String.valueOf(permission) + ")=>" + b);
            }
            if (b == null) continue;
            return b;
        }
        return null;
    }

    protected abstract Boolean hasPermission(Sid var1, Permission var2);

    protected String toString(Sid p) {
        if (p instanceof GrantedAuthoritySid) {
            return ((GrantedAuthoritySid)p).getGrantedAuthority();
        }
        if (p instanceof PrincipalSid) {
            return ((PrincipalSid)p).getPrincipal();
        }
        if (p == EVERYONE) {
            return "role_everyone";
        }
        return p.toString();
    }

    public final SidACL newInheritingACL(final SidACL parent) {
        final SidACL child = this;
        return new SidACL(){

            @Override
            protected Boolean hasPermission(Sid p, Permission permission) {
                Boolean b = child.hasPermission(p, permission);
                if (b != null) {
                    return b;
                }
                return parent.hasPermission(p, permission);
            }
        };
    }
}

