/*
 * Decompiled with CFR 0.152.
 */
package jenkins.fingerprints;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.Functions;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Fingerprint;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.Date;
import jenkins.fingerprints.FileFingerprintStorage;
import jenkins.fingerprints.FingerprintStorageDescriptor;
import jenkins.fingerprints.GlobalFingerprintConfiguration;
import jenkins.model.FingerprintFacet;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.Beta;

@Restricted(value={Beta.class})
public abstract class FingerprintStorage
extends AbstractDescribableImpl<FingerprintStorage>
implements ExtensionPoint {
    public static FingerprintStorage get() {
        return ExtensionList.lookupSingleton(GlobalFingerprintConfiguration.class).getStorage();
    }

    @Deprecated
    public static FingerprintStorage getFileFingerprintStorage() {
        return ExtensionList.lookupSingleton(FileFingerprintStorage.class);
    }

    public abstract void save(Fingerprint var1) throws IOException;

    @CheckForNull
    public abstract Fingerprint load(String var1) throws IOException;

    public abstract void delete(String var1) throws IOException;

    public abstract boolean isReady();

    public abstract void iterateAndCleanupFingerprints(TaskListener var1);

    public boolean cleanFingerprint(@NonNull Fingerprint fingerprint, TaskListener taskListener) {
        try {
            if (!fingerprint.isAlive() && fingerprint.getFacetBlockingDeletion() == null) {
                taskListener.getLogger().println("deleting obsolete " + String.valueOf(fingerprint));
                Fingerprint.delete(fingerprint.getHashString());
                return true;
            }
            if (!fingerprint.isAlive()) {
                FingerprintFacet deletionBlockerFacet = fingerprint.getFacetBlockingDeletion();
                taskListener.getLogger().println(deletionBlockerFacet.getClass().getName() + " created on " + String.valueOf(new Date(deletionBlockerFacet.getTimestamp())) + " blocked deletion of " + fingerprint.getHashString());
            }
            fingerprint = this.getFingerprint(fingerprint);
            return fingerprint.trim();
        }
        catch (IOException e) {
            Functions.printStackTrace((Throwable)e, taskListener.error("Failed to process " + fingerprint.getHashString()));
            return false;
        }
    }

    protected Fingerprint getFingerprint(Fingerprint fp) throws IOException {
        return Jenkins.get()._getFingerprint(fp.getHashString());
    }

    public FingerprintStorageDescriptor getDescriptor() {
        return (FingerprintStorageDescriptor)super.getDescriptor();
    }
}

