/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import hudson.Extension;
import hudson.Plugin;
import hudson.PluginWrapper;
import hudson.StructuredForm;
import hudson.model.Descriptor;
import jakarta.servlet.ServletException;
import java.io.IOException;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.StaplerRequest2;

@Extension(ordinal=100.0)
@Symbol(value={"plugin"})
public class GlobalPluginConfiguration
extends GlobalConfiguration {
    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        try {
            for (JSONObject o : StructuredForm.toList(json, "plugin")) {
                Plugin p;
                String pluginName = o.getString("name");
                PluginWrapper pw = Jenkins.get().pluginManager.getPlugin(pluginName);
                Plugin plugin = p = pw != null ? pw.getPlugin() : null;
                if (p == null) {
                    throw new Descriptor.FormException("Cannot find the plugin instance: " + pluginName, "plugin");
                }
                p.configure(req, o);
            }
            return true;
        }
        catch (ServletException | IOException e) {
            throw new Descriptor.FormException(e, "plugin");
        }
    }
}

