/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import hudson.util.AtomicFileWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class RunIdMigrator {
    private final DateFormat legacyIdFormatter = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    static final Logger LOGGER = Logger.getLogger(RunIdMigrator.class.getName());
    private static final String MAP_FILE = "legacyIds";
    private static final Map<String, Integer> EMPTY = new TreeMap<String, Integer>();
    @NonNull
    private Map<String, Integer> idToNumber = EMPTY;
    private static final Pattern NUMBER_ELT = Pattern.compile("(?m)^  <number>(\\d+)</number>(\r?\n)");

    private boolean load(File dir) {
        File f = new File(dir, MAP_FILE);
        if (!f.isFile()) {
            return false;
        }
        if (f.length() == 0L) {
            return true;
        }
        this.idToNumber = new TreeMap<String, Integer>();
        try {
            for (String line : Files.readAllLines(Util.fileToPath(f), StandardCharsets.UTF_8)) {
                int i = line.indexOf(32);
                this.idToNumber.put(line.substring(0, i), Integer.parseInt(line.substring(i + 1)));
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "could not read from " + String.valueOf(f), x);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save(File dir) {
        File f = new File(dir, MAP_FILE);
        try (AtomicFileWriter w = new AtomicFileWriter(f);){
            try {
                RunIdMigrator runIdMigrator = this;
                synchronized (runIdMigrator) {
                    for (Map.Entry<String, Integer> entry : this.idToNumber.entrySet()) {
                        w.write(entry.getKey() + " " + String.valueOf(entry.getValue()) + "\n");
                    }
                }
                w.commit();
            }
            finally {
                w.abort();
            }
        }
        catch (IOException x) {
            LOGGER.log(Level.WARNING, "could not save changes to " + String.valueOf(f), x);
        }
    }

    public void created(File dir) {
        this.save(dir);
    }

    public synchronized boolean migrate(File dir, @CheckForNull File jenkinsHome) {
        if (this.load(dir)) {
            LOGGER.log(Level.FINER, "migration already performed for {0}", dir);
            return false;
        }
        if (!dir.isDirectory()) {
            LOGGER.log(Level.FINE, "{0} was unexpectedly missing", dir);
            return false;
        }
        LOGGER.log(Level.INFO, "Migrating build records in {0}. See https://www.jenkins.io/redirect/build-record-migration for more information.", dir);
        this.doMigrate(dir);
        this.save(dir);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMigrate(File dir) {
        String name;
        this.idToNumber = new TreeMap<String, Integer>();
        File[] kids = dir.listFiles();
        ArrayList<File> kidsList = new ArrayList<File>(Arrays.asList(kids));
        Iterator it = kidsList.iterator();
        while (it.hasNext()) {
            File kid = (File)it.next();
            name = kid.getName();
            try {
                Integer.parseInt(name);
            }
            catch (NumberFormatException x) {
                LOGGER.log(Level.FINE, "ignoring nonnumeric entry {0}", name);
                continue;
            }
            try {
                if (Util.isSymlink(kid)) {
                    LOGGER.log(Level.FINE, "deleting build number symlink {0} \u2192 {1}", new Object[]{name, Util.resolveSymlink(kid)});
                } else {
                    if (kid.isDirectory()) {
                        LOGGER.log(Level.FINE, "ignoring build directory {0}", name);
                        continue;
                    }
                    LOGGER.log(Level.WARNING, "need to delete anomalous file entry {0}", name);
                }
                Util.deleteFile(kid);
                it.remove();
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to process " + String.valueOf(kid), x);
            }
        }
        for (File kid : kidsList) {
            try {
                name = kid.getName();
                try {
                    Integer.parseInt(name);
                    LOGGER.log(Level.FINE, "skipping new build dir {0}", name);
                }
                catch (NumberFormatException x) {
                    long timestamp;
                    if (!kid.isDirectory()) {
                        LOGGER.log(Level.FINE, "skipping non-directory {0}", name);
                        continue;
                    }
                    try {
                        DateFormat dateFormat = this.legacyIdFormatter;
                        synchronized (dateFormat) {
                            timestamp = this.legacyIdFormatter.parse(name).getTime();
                        }
                    }
                    catch (ParseException x2) {
                        LOGGER.log(Level.WARNING, "found unexpected dir {0}", name);
                        continue;
                    }
                    File buildXml = new File(kid, "build.xml");
                    if (!buildXml.isFile()) {
                        LOGGER.log(Level.WARNING, "found no build.xml in {0}", name);
                        continue;
                    }
                    String xml = Files.readString(Util.fileToPath(buildXml), StandardCharsets.UTF_8);
                    Matcher m = NUMBER_ELT.matcher(xml);
                    if (!m.find()) {
                        LOGGER.log(Level.WARNING, "could not find <number> in {0}/build.xml", name);
                        continue;
                    }
                    int number = Integer.parseInt(m.group(1));
                    String nl = m.group(2);
                    xml = m.replaceFirst("  <id>" + name + "</id>" + nl + "  <timestamp>" + timestamp + "</timestamp>" + nl);
                    File newKid = new File(dir, Integer.toString(number));
                    RunIdMigrator.move(kid, newKid);
                    Files.writeString(Util.fileToPath(newKid).resolve("build.xml"), (CharSequence)xml, StandardCharsets.UTF_8, new OpenOption[0]);
                    LOGGER.log(Level.FINE, "fully processed {0} \u2192 {1}", new Object[]{name, number});
                    this.idToNumber.put(name, number);
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to process " + String.valueOf(kid), x);
            }
        }
    }

    static void move(File src, File dest) throws IOException {
        try {
            Files.move(src.toPath(), dest.toPath(), new CopyOption[0]);
        }
        catch (IOException x) {
            throw x;
        }
        catch (RuntimeException x) {
            throw new IOException(x);
        }
    }

    public synchronized int findNumber(@NonNull String id) {
        Integer number = this.idToNumber.get(id);
        return number != null ? number : 0;
    }

    public synchronized void delete(File dir, String id) {
        if (this.idToNumber.remove(id) != null) {
            this.save(dir);
        }
    }
}

