/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.model.User;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.ScriptListener;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class DefaultScriptListener
implements ScriptListener {
    public static final Logger LOGGER = Logger.getLogger(DefaultScriptListener.class.getName());

    @Override
    public void onScriptExecution(String script, Binding binding, @NonNull Object feature, Object context, @NonNull String correlationId, User user) {
        String userFragment = user == null ? " (no user)" : " by user: '" + String.valueOf(user) + "'";
        LOGGER.log(Level.FINE, LOGGER.isLoggable(Level.FINEST) ? new Exception() : null, () -> "Execution of script: '" + script + "' with binding: '" + DefaultScriptListener.stringifyBinding(binding) + "' in feature: '" + String.valueOf(feature) + "' and context: '" + String.valueOf(context) + "' with correlation: '" + correlationId + "'" + userFragment);
    }

    @Override
    public void onScriptOutput(String output, @NonNull Object feature, Object context, @NonNull String correlationId, User user) {
        String userFragment = user == null ? " (no user)" : " for user: '" + String.valueOf(user) + "'";
        LOGGER.log(Level.FINER, LOGGER.isLoggable(Level.FINEST) ? new Exception() : null, () -> "Script output: '" + output + "' in feature: '" + String.valueOf(feature) + "' and context: '" + String.valueOf(context) + "' with correlation: '" + correlationId + "'" + userFragment);
    }

    private static String stringifyBinding(Binding binding) {
        if (binding == null) {
            return null;
        }
        return InvokerHelper.toString((Object)binding.getVariables());
    }
}

