/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util.io;

import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class FileBoolean {
    private final File file;
    private volatile Boolean state;
    private static final Logger LOGGER = Logger.getLogger(FileBoolean.class.getName());

    public FileBoolean(File file) {
        this.file = file;
    }

    public FileBoolean(Class owner, String name) {
        this(new File(Jenkins.get().getRootDir(), owner.getName().replace('$', '.') + "/" + name));
    }

    public boolean get() {
        this.state = this.file.exists();
        return this.state;
    }

    public boolean fastGet() {
        if (this.state == null) {
            return this.get();
        }
        return this.state;
    }

    public boolean isOn() {
        return this.get();
    }

    public boolean isOff() {
        return !this.get();
    }

    public void set(boolean b) {
        if (b) {
            this.on();
        } else {
            this.off();
        }
    }

    public void on() {
        try {
            Util.createDirectories(this.file.getParentFile().toPath(), new FileAttribute[0]);
            Files.newOutputStream(this.file.toPath(), new OpenOption[0]).close();
            this.get();
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.log(Level.WARNING, "Failed to touch " + String.valueOf(this.file));
        }
    }

    public void off() {
        try {
            Files.deleteIfExists(this.file.toPath());
            this.get();
        }
        catch (IOException | InvalidPathException e) {
            LOGGER.log(Level.WARNING, "Failed to delete " + String.valueOf(this.file));
        }
    }
}

