/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Job;
import java.io.IOException;
import jenkins.model.BuildDiscarder;
import jenkins.model.GlobalBuildDiscarderStrategy;
import jenkins.model.GlobalBuildDiscarderStrategyDescriptor;
import jenkins.model.Messages;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

@Restricted(value={NoExternalUse.class})
public class SimpleGlobalBuildDiscarderStrategy
extends GlobalBuildDiscarderStrategy {
    private BuildDiscarder discarder;

    @DataBoundConstructor
    public SimpleGlobalBuildDiscarderStrategy(BuildDiscarder discarder) {
        this.discarder = discarder;
    }

    public BuildDiscarder getDiscarder() {
        return this.discarder;
    }

    @Override
    public boolean isApplicable(Job<?, ?> job) {
        return true;
    }

    public void apply(Job<?, ?> job) throws IOException, InterruptedException {
        if (this.discarder != null) {
            this.discarder.perform(job);
        }
    }

    @Extension
    @Symbol(value={"simpleBuildDiscarder"})
    public static class DescriptorImpl
    extends GlobalBuildDiscarderStrategyDescriptor {
        @Override
        @NonNull
        public String getDisplayName() {
            return Messages.SimpleGlobalBuildDiscarderStrategy_displayName();
        }
    }
}

