// CHECKSTYLE:OFF

package jenkins.agents;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code CloudSet.NoSuchCloud}: {@code No such cloud: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such cloud: {0}}
     */
    public static String CloudSet_NoSuchCloud(Object arg0) {
        return holder.format("CloudSet.NoSuchCloud", arg0);
    }

    /**
     * Key {@code CloudSet.NoSuchCloud}: {@code No such cloud: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code No such cloud: {0}}
     */
    public static Localizable _CloudSet_NoSuchCloud(Object arg0) {
        return new Localizable(holder, "CloudSet.NoSuchCloud", arg0);
    }

    /**
     * Key {@code CloudSet.DisplayName}: {@code Clouds}.
     * 
     * @return
     *     {@code Clouds}
     */
    public static String CloudSet_DisplayName() {
        return holder.format("CloudSet.DisplayName");
    }

    /**
     * Key {@code CloudSet.DisplayName}: {@code Clouds}.
     * 
     * @return
     *     {@code Clouds}
     */
    public static Localizable _CloudSet_DisplayName() {
        return new Localizable(holder, "CloudSet.DisplayName");
    }

    /**
     * Key {@code CloudsLink.Description}: {@code Add, remove, and configure
     * cloud instances to provision agents on-demand.}.
     * 
     * @return
     *     {@code Add, remove, and configure cloud instances to provision agents
     *     on-demand.}
     */
    public static String CloudsLink_Description() {
        return holder.format("CloudsLink.Description");
    }

    /**
     * Key {@code CloudsLink.Description}: {@code Add, remove, and configure
     * cloud instances to provision agents on-demand.}.
     * 
     * @return
     *     {@code Add, remove, and configure cloud instances to provision agents
     *     on-demand.}
     */
    public static Localizable _CloudsLink_Description() {
        return new Localizable(holder, "CloudsLink.Description");
    }

    /**
     * Key {@code IOfflineCause.offline}: {@code Offline}.
     * 
     * @return
     *     {@code Offline}
     */
    public static String IOfflineCause_offline() {
        return holder.format("IOfflineCause.offline");
    }

    /**
     * Key {@code IOfflineCause.offline}: {@code Offline}.
     * 
     * @return
     *     {@code Offline}
     */
    public static Localizable _IOfflineCause_offline() {
        return new Localizable(holder, "IOfflineCause.offline");
    }

    /**
     * Key {@code CloudsLink.DisplayName}: {@code Clouds}.
     * 
     * @return
     *     {@code Clouds}
     */
    public static String CloudsLink_DisplayName() {
        return holder.format("CloudsLink.DisplayName");
    }

    /**
     * Key {@code CloudsLink.DisplayName}: {@code Clouds}.
     * 
     * @return
     *     {@code Clouds}
     */
    public static Localizable _CloudsLink_DisplayName() {
        return new Localizable(holder, "CloudsLink.DisplayName");
    }

    /**
     * Key {@code CloudSet.CloudAlreadyExists}: {@code Cloud called â{0}â
     * already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cloud called â{0}â already exists}
     */
    public static String CloudSet_CloudAlreadyExists(Object arg0) {
        return holder.format("CloudSet.CloudAlreadyExists", arg0);
    }

    /**
     * Key {@code CloudSet.CloudAlreadyExists}: {@code Cloud called â{0}â
     * already exists}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Cloud called â{0}â already exists}
     */
    public static Localizable _CloudSet_CloudAlreadyExists(Object arg0) {
        return new Localizable(holder, "CloudSet.CloudAlreadyExists", arg0);
    }

    /**
     * Key {@code CloudSet.SpecifyCloudToCopy}: {@code Specify which cloud to
     * copy}.
     * 
     * @return
     *     {@code Specify which cloud to copy}
     */
    public static String CloudSet_SpecifyCloudToCopy() {
        return holder.format("CloudSet.SpecifyCloudToCopy");
    }

    /**
     * Key {@code CloudSet.SpecifyCloudToCopy}: {@code Specify which cloud to
     * copy}.
     * 
     * @return
     *     {@code Specify which cloud to copy}
     */
    public static Localizable _CloudSet_SpecifyCloudToCopy() {
        return new Localizable(holder, "CloudSet.SpecifyCloudToCopy");
    }

}
