/*
 * The MIT License
 *
 * Copyright (c) 2016, CloudBees, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package jenkins.management;

import hudson.Extension;
import hudson.model.AdministrativeMonitor;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Restricted(NoExternalUse.class)
public class AdministrativeMonitorsConfiguration extends GlobalConfiguration {
    @Override
    public boolean configure(StaplerRequest2 req, JSONObject json) throws FormException {
        JSONArray monitors = json.optJSONArray("administrativeMonitor");
        for (AdministrativeMonitor am : AdministrativeMonitor.all()) {
            try {
                boolean disable;
                if (monitors != null) {
                    disable = !monitors.contains(am.id);
                } else {
                    disable = !am.id.equals(json.optString("administrativeMonitor"));
                }
                am.disable(disable);
            } catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to process form submission for " + am.id, e);
            }
        }
        return true;
    }

    private static Logger LOGGER = Logger.getLogger(AdministrativeMonitorsConfiguration.class.getName());
}
