// CHECKSTYLE:OFF

package jenkins.model.item_category;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code StandaloneProjects.DisplayName}: {@code Standalone
     * Projects}.
     * 
     * @return
     *     {@code Standalone Projects}
     */
    public static String StandaloneProjects_DisplayName() {
        return holder.format("StandaloneProjects.DisplayName");
    }

    /**
     * Key {@code StandaloneProjects.DisplayName}: {@code Standalone
     * Projects}.
     * 
     * @return
     *     {@code Standalone Projects}
     */
    public static Localizable _StandaloneProjects_DisplayName() {
        return new Localizable(holder, "StandaloneProjects.DisplayName");
    }

    /**
     * Key {@code NestedProjects.DisplayName}: {@code Nested Projects}.
     * 
     * @return
     *     {@code Nested Projects}
     */
    public static String NestedProjects_DisplayName() {
        return holder.format("NestedProjects.DisplayName");
    }

    /**
     * Key {@code NestedProjects.DisplayName}: {@code Nested Projects}.
     * 
     * @return
     *     {@code Nested Projects}
     */
    public static Localizable _NestedProjects_DisplayName() {
        return new Localizable(holder, "NestedProjects.DisplayName");
    }

    /**
     * Key {@code NestedProjects.Description}: {@code Create project
     * categories or project hierarchies with folders. Folders can be created
     * manually or automatically based on repositories.}.
     * 
     * @return
     *     {@code Create project categories or project hierarchies with folders.
     *     Folders can be created manually or automatically based on
     *     repositories.}
     */
    public static String NestedProjects_Description() {
        return holder.format("NestedProjects.Description");
    }

    /**
     * Key {@code NestedProjects.Description}: {@code Create project
     * categories or project hierarchies with folders. Folders can be created
     * manually or automatically based on repositories.}.
     * 
     * @return
     *     {@code Create project categories or project hierarchies with folders.
     *     Folders can be created manually or automatically based on
     *     repositories.}
     */
    public static Localizable _NestedProjects_Description() {
        return new Localizable(holder, "NestedProjects.Description");
    }

    /**
     * Key {@code StandaloneProjects.Description}: {@code Create projects
     * with a self-contained configuration and history. These projects can be
     * at the top-level or grouped within folders.}.
     * 
     * @return
     *     {@code Create projects with a self-contained configuration and
     *     history. These projects can be at the top-level or grouped within
     *     folders.}
     */
    public static String StandaloneProjects_Description() {
        return holder.format("StandaloneProjects.Description");
    }

    /**
     * Key {@code StandaloneProjects.Description}: {@code Create projects
     * with a self-contained configuration and history. These projects can be
     * at the top-level or grouped within folders.}.
     * 
     * @return
     *     {@code Create projects with a self-contained configuration and
     *     history. These projects can be at the top-level or grouped within
     *     folders.}
     */
    public static Localizable _StandaloneProjects_Description() {
        return new Localizable(holder, "StandaloneProjects.Description");
    }

    /**
     * Key {@code Uncategorized.Description}: {@code Item types that have not
     * yet been categorized by their plugin maintainer.}.
     * 
     * @return
     *     {@code Item types that have not yet been categorized by their plugin
     *     maintainer.}
     */
    public static String Uncategorized_Description() {
        return holder.format("Uncategorized.Description");
    }

    /**
     * Key {@code Uncategorized.Description}: {@code Item types that have not
     * yet been categorized by their plugin maintainer.}.
     * 
     * @return
     *     {@code Item types that have not yet been categorized by their plugin
     *     maintainer.}
     */
    public static Localizable _Uncategorized_Description() {
        return new Localizable(holder, "Uncategorized.Description");
    }

    /**
     * Key {@code Uncategorized.DisplayName}: {@code Uncategorized}.
     * 
     * @return
     *     {@code Uncategorized}
     */
    public static String Uncategorized_DisplayName() {
        return holder.format("Uncategorized.DisplayName");
    }

    /**
     * Key {@code Uncategorized.DisplayName}: {@code Uncategorized}.
     * 
     * @return
     *     {@code Uncategorized}
     */
    public static Localizable _Uncategorized_DisplayName() {
        return new Localizable(holder, "Uncategorized.DisplayName");
    }

}
