// CHECKSTYLE:OFF

package jenkins.security;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ApiTokenProperty.lastUsedAMonthAgo}: {@code Last used over
     * a month ago}.
     * 
     * @return
     *     {@code Last used over a month ago}
     */
    public static String ApiTokenProperty_lastUsedAMonthAgo() {
        return holder.format("ApiTokenProperty.lastUsedAMonthAgo");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedAMonthAgo}: {@code Last used over
     * a month ago}.
     * 
     * @return
     *     {@code Last used over a month ago}
     */
    public static Localizable _ApiTokenProperty_lastUsedAMonthAgo() {
        return new Localizable(holder, "ApiTokenProperty.lastUsedAMonthAgo");
    }

    /**
     * Key {@code ApiTokenProperty.LegacyTokenName}: {@code Legacy Token}.
     * 
     * @return
     *     {@code Legacy Token}
     */
    public static String ApiTokenProperty_LegacyTokenName() {
        return holder.format("ApiTokenProperty.LegacyTokenName");
    }

    /**
     * Key {@code ApiTokenProperty.LegacyTokenName}: {@code Legacy Token}.
     * 
     * @return
     *     {@code Legacy Token}
     */
    public static Localizable _ApiTokenProperty_LegacyTokenName() {
        return new Localizable(holder, "ApiTokenProperty.LegacyTokenName");
    }

    /**
     * Key {@code ApiTokenProperty.NoLegacyToken}: {@code This user currently
     * does not have a legacy token}.
     * 
     * @return
     *     {@code This user currently does not have a legacy token}
     */
    public static String ApiTokenProperty_NoLegacyToken() {
        return holder.format("ApiTokenProperty.NoLegacyToken");
    }

    /**
     * Key {@code ApiTokenProperty.NoLegacyToken}: {@code This user currently
     * does not have a legacy token}.
     * 
     * @return
     *     {@code This user currently does not have a legacy token}
     */
    public static Localizable _ApiTokenProperty_NoLegacyToken() {
        return new Localizable(holder, "ApiTokenProperty.NoLegacyToken");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.TokenIsHidden}: {@code Token
     * is hidden}.
     * 
     * @return
     *     {@code Token is hidden}
     */
    public static String ApiTokenProperty_ChangeToken_TokenIsHidden() {
        return holder.format("ApiTokenProperty.ChangeToken.TokenIsHidden");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.TokenIsHidden}: {@code Token
     * is hidden}.
     * 
     * @return
     *     {@code Token is hidden}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_TokenIsHidden() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.TokenIsHidden");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedYearsAgo}: {@code Last used over
     * {0} years ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used over {0} years ago}
     */
    public static String ApiTokenProperty_lastUsedYearsAgo(Object arg0) {
        return holder.format("ApiTokenProperty.lastUsedYearsAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedYearsAgo}: {@code Last used over
     * {0} years ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used over {0} years ago}
     */
    public static Localizable _ApiTokenProperty_lastUsedYearsAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.lastUsedYearsAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.Success}: {@code <div>Updated.
     * See the new token in the field above</div>}.
     * 
     * @return
     *     {@code <div>Updated. See the new token in the field above</div>}
     */
    public static String ApiTokenProperty_ChangeToken_Success() {
        return holder.format("ApiTokenProperty.ChangeToken.Success");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.Success}: {@code <div>Updated.
     * See the new token in the field above</div>}.
     * 
     * @return
     *     {@code <div>Updated. See the new token in the field above</div>}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_Success() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.Success");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedWeeksAgo}: {@code Last used over
     * {0} weeks ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used over {0} weeks ago}
     */
    public static String ApiTokenProperty_lastUsedWeeksAgo(Object arg0) {
        return holder.format("ApiTokenProperty.lastUsedWeeksAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedWeeksAgo}: {@code Last used over
     * {0} weeks ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used over {0} weeks ago}
     */
    public static Localizable _ApiTokenProperty_lastUsedWeeksAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.lastUsedWeeksAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.createdYearsAgo}: {@code Created {0} years
     * ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} years ago}
     */
    public static String ApiTokenProperty_createdYearsAgo(Object arg0) {
        return holder.format("ApiTokenProperty.createdYearsAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.createdYearsAgo}: {@code Created {0} years
     * ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} years ago}
     */
    public static Localizable _ApiTokenProperty_createdYearsAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.createdYearsAgo", arg0);
    }

    /**
     * Key {@code UpdateSiteWarningsMonitor.DisplayName}: {@code Update Site
     * Warnings}.
     * 
     * @return
     *     {@code Update Site Warnings}
     */
    public static String UpdateSiteWarningsMonitor_DisplayName() {
        return holder.format("UpdateSiteWarningsMonitor.DisplayName");
    }

    /**
     * Key {@code UpdateSiteWarningsMonitor.DisplayName}: {@code Update Site
     * Warnings}.
     * 
     * @return
     *     {@code Update Site Warnings}
     */
    public static Localizable _UpdateSiteWarningsMonitor_DisplayName() {
        return new Localizable(holder, "UpdateSiteWarningsMonitor.DisplayName");
    }

    /**
     * Key {@code ApiTokenProperty.createdDaysAgo}: {@code Created {0} days
     * ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} days ago}
     */
    public static String ApiTokenProperty_createdDaysAgo(Object arg0) {
        return holder.format("ApiTokenProperty.createdDaysAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.createdDaysAgo}: {@code Created {0} days
     * ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} days ago}
     */
    public static Localizable _ApiTokenProperty_createdDaysAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.createdDaysAgo", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.FailedIdentityCheck}: {@code An
     * error occurred when checking the instance identity at that URL: {0}
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred when checking the instance identity at that
     *     URL: {0} {1}}
     */
    public static String ResourceDomainConfiguration_FailedIdentityCheck(Object arg0, Object arg1) {
        return holder.format("ResourceDomainConfiguration.FailedIdentityCheck", arg0, arg1);
    }

    /**
     * Key {@code ResourceDomainConfiguration.FailedIdentityCheck}: {@code An
     * error occurred when checking the instance identity at that URL: {0}
     * {1}}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An error occurred when checking the instance identity at that
     *     URL: {0} {1}}
     */
    public static Localizable _ResourceDomainConfiguration_FailedIdentityCheck(Object arg0, Object arg1) {
        return new Localizable(holder, "ResourceDomainConfiguration.FailedIdentityCheck", arg0, arg1);
    }

    /**
     * Key {@code ApiTokenProperty.createdWeeksAgo}: {@code Created {0} weeks
     * ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} weeks ago}
     */
    public static String ApiTokenProperty_createdWeeksAgo(Object arg0) {
        return holder.format("ApiTokenProperty.createdWeeksAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.createdWeeksAgo}: {@code Created {0} weeks
     * ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} weeks ago}
     */
    public static Localizable _ApiTokenProperty_createdWeeksAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.createdWeeksAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedToday}: {@code Last used today}.
     * 
     * @return
     *     {@code Last used today}
     */
    public static String ApiTokenProperty_lastUsedToday() {
        return holder.format("ApiTokenProperty.lastUsedToday");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedToday}: {@code Last used today}.
     * 
     * @return
     *     {@code Last used today}
     */
    public static Localizable _ApiTokenProperty_lastUsedToday() {
        return new Localizable(holder, "ApiTokenProperty.lastUsedToday");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.SuccessHidden}: {@code
     * <div>Updated. You need to login as the user to see the token</div>}.
     * 
     * @return
     *     {@code <div>Updated. You need to login as the user to see the
     *     token</div>}
     */
    public static String ApiTokenProperty_ChangeToken_SuccessHidden() {
        return holder.format("ApiTokenProperty.ChangeToken.SuccessHidden");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.SuccessHidden}: {@code
     * <div>Updated. You need to login as the user to see the token</div>}.
     * 
     * @return
     *     {@code <div>Updated. You need to login as the user to see the
     *     token</div>}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_SuccessHidden() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.SuccessHidden");
    }

    /**
     * Key {@code ResourceDomainConfiguration.InvalidRootURL}: {@code Jenkins
     * URL is set to an invalid value, please report a bug: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Jenkins URL is set to an invalid value, please report a bug:
     *     {0}}
     */
    public static String ResourceDomainConfiguration_InvalidRootURL(Object arg0) {
        return holder.format("ResourceDomainConfiguration.InvalidRootURL", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.InvalidRootURL}: {@code Jenkins
     * URL is set to an invalid value, please report a bug: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Jenkins URL is set to an invalid value, please report a bug:
     *     {0}}
     */
    public static Localizable _ResourceDomainConfiguration_InvalidRootURL(Object arg0) {
        return new Localizable(holder, "ResourceDomainConfiguration.InvalidRootURL", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.createdAMonthAgo}: {@code Created over a
     * month ago}.
     * 
     * @return
     *     {@code Created over a month ago}
     */
    public static String ApiTokenProperty_createdAMonthAgo() {
        return holder.format("ApiTokenProperty.createdAMonthAgo");
    }

    /**
     * Key {@code ApiTokenProperty.createdAMonthAgo}: {@code Created over a
     * month ago}.
     * 
     * @return
     *     {@code Created over a month ago}
     */
    public static Localizable _ApiTokenProperty_createdAMonthAgo() {
        return new Localizable(holder, "ApiTokenProperty.createdAMonthAgo");
    }

    /**
     * Key {@code ResourceDomainConfiguration.DisplayName}: {@code Resource
     * Domain Recommendation}.
     * 
     * @return
     *     {@code Resource Domain Recommendation}
     */
    public static String ResourceDomainConfiguration_DisplayName() {
        return holder.format("ResourceDomainConfiguration.DisplayName");
    }

    /**
     * Key {@code ResourceDomainConfiguration.DisplayName}: {@code Resource
     * Domain Recommendation}.
     * 
     * @return
     *     {@code Resource Domain Recommendation}
     */
    public static Localizable _ResourceDomainConfiguration_DisplayName() {
        return new Localizable(holder, "ResourceDomainConfiguration.DisplayName");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Empty}: {@code Without a
     * resource root URL, resources will be served from the Jenkins URL with
     * Content-Security-Policy set.}.
     * 
     * @return
     *     {@code Without a resource root URL, resources will be served from the
     *     Jenkins URL with Content-Security-Policy set.}
     */
    public static String ResourceDomainConfiguration_Empty() {
        return holder.format("ResourceDomainConfiguration.Empty");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Empty}: {@code Without a
     * resource root URL, resources will be served from the Jenkins URL with
     * Content-Security-Policy set.}.
     * 
     * @return
     *     {@code Without a resource root URL, resources will be served from the
     *     Jenkins URL with Content-Security-Policy set.}
     */
    public static Localizable _ResourceDomainConfiguration_Empty() {
        return new Localizable(holder, "ResourceDomainConfiguration.Empty");
    }

    /**
     * Key {@code ResourceDomainConfiguration.OtherJenkins}: {@code The
     * specified URL points to a different Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL points to a different Jenkins instance.}
     */
    public static String ResourceDomainConfiguration_OtherJenkins() {
        return holder.format("ResourceDomainConfiguration.OtherJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.OtherJenkins}: {@code The
     * specified URL points to a different Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL points to a different Jenkins instance.}
     */
    public static Localizable _ResourceDomainConfiguration_OtherJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.OtherJenkins");
    }

    /**
     * Key {@code ApiTokenProperty.createdMonthsAgo}: {@code Created {0}
     * months ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} months ago}
     */
    public static String ApiTokenProperty_createdMonthsAgo(Object arg0) {
        return holder.format("ApiTokenProperty.createdMonthsAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.createdMonthsAgo}: {@code Created {0}
     * months ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created {0} months ago}
     */
    public static Localizable _ApiTokenProperty_createdMonthsAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.createdMonthsAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedAYearAgo}: {@code Last used over a
     * year ago}.
     * 
     * @return
     *     {@code Last used over a year ago}
     */
    public static String ApiTokenProperty_lastUsedAYearAgo() {
        return holder.format("ApiTokenProperty.lastUsedAYearAgo");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedAYearAgo}: {@code Last used over a
     * year ago}.
     * 
     * @return
     *     {@code Last used over a year ago}
     */
    public static Localizable _ApiTokenProperty_lastUsedAYearAgo() {
        return new Localizable(holder, "ApiTokenProperty.lastUsedAYearAgo");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NotJenkins}: {@code The
     * specified URL does not appear to point to a Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL does not appear to point to a Jenkins
     *     instance.}
     */
    public static String ResourceDomainConfiguration_NotJenkins() {
        return holder.format("ResourceDomainConfiguration.NotJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NotJenkins}: {@code The
     * specified URL does not appear to point to a Jenkins instance.}.
     * 
     * @return
     *     {@code The specified URL does not appear to point to a Jenkins
     *     instance.}
     */
    public static Localizable _ResourceDomainConfiguration_NotJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.NotJenkins");
    }

    /**
     * Key {@code ApiTokenProperty.createdToday}: {@code Created today}.
     * 
     * @return
     *     {@code Created today}
     */
    public static String ApiTokenProperty_createdToday() {
        return holder.format("ApiTokenProperty.createdToday");
    }

    /**
     * Key {@code ApiTokenProperty.createdToday}: {@code Created today}.
     * 
     * @return
     *     {@code Created today}
     */
    public static Localizable _ApiTokenProperty_createdToday() {
        return new Localizable(holder, "ApiTokenProperty.createdToday");
    }

    /**
     * Key {@code ApiTokenProperty.createdAYearAgo}: {@code Created over a
     * year ago}.
     * 
     * @return
     *     {@code Created over a year ago}
     */
    public static String ApiTokenProperty_createdAYearAgo() {
        return holder.format("ApiTokenProperty.createdAYearAgo");
    }

    /**
     * Key {@code ApiTokenProperty.createdAYearAgo}: {@code Created over a
     * year ago}.
     * 
     * @return
     *     {@code Created over a year ago}
     */
    public static Localizable _ApiTokenProperty_createdAYearAgo() {
        return new Localizable(holder, "ApiTokenProperty.createdAYearAgo");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NeedsRootURL}: {@code Can only
     * set resource root URL if Jenkins URL is set.}.
     * 
     * @return
     *     {@code Can only set resource root URL if Jenkins URL is set.}
     */
    public static String ResourceDomainConfiguration_NeedsRootURL() {
        return holder.format("ResourceDomainConfiguration.NeedsRootURL");
    }

    /**
     * Key {@code ResourceDomainConfiguration.NeedsRootURL}: {@code Can only
     * set resource root URL if Jenkins URL is set.}.
     * 
     * @return
     *     {@code Can only set resource root URL if Jenkins URL is set.}
     */
    public static Localizable _ResourceDomainConfiguration_NeedsRootURL() {
        return new Localizable(holder, "ResourceDomainConfiguration.NeedsRootURL");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.CapabilityNotAllowed}: {@code
     * <div>Capability to generate a legacy token without an existing one is
     * currently disabled in the security configuration</div>}.
     * 
     * @return
     *     {@code <div>Capability to generate a legacy token without an existing
     *     one is currently disabled in the security configuration</div>}
     */
    public static String ApiTokenProperty_ChangeToken_CapabilityNotAllowed() {
        return holder.format("ApiTokenProperty.ChangeToken.CapabilityNotAllowed");
    }

    /**
     * Key {@code ApiTokenProperty.ChangeToken.CapabilityNotAllowed}: {@code
     * <div>Capability to generate a legacy token without an existing one is
     * currently disabled in the security configuration</div>}.
     * 
     * @return
     *     {@code <div>Capability to generate a legacy token without an existing
     *     one is currently disabled in the security configuration</div>}
     */
    public static Localizable _ApiTokenProperty_ChangeToken_CapabilityNotAllowed() {
        return new Localizable(holder, "ApiTokenProperty.ChangeToken.CapabilityNotAllowed");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedYesterday}: {@code Last used
     * yesterday}.
     * 
     * @return
     *     {@code Last used yesterday}
     */
    public static String ApiTokenProperty_lastUsedYesterday() {
        return holder.format("ApiTokenProperty.lastUsedYesterday");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedYesterday}: {@code Last used
     * yesterday}.
     * 
     * @return
     *     {@code Last used yesterday}
     */
    public static Localizable _ApiTokenProperty_lastUsedYesterday() {
        return new Localizable(holder, "ApiTokenProperty.lastUsedYesterday");
    }

    /**
     * Key {@code ResourceDomainConfiguration.IOException}: {@code Failed to
     * connect: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect: {0}}
     */
    public static String ResourceDomainConfiguration_IOException(Object arg0) {
        return holder.format("ResourceDomainConfiguration.IOException", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.IOException}: {@code Failed to
     * connect: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Failed to connect: {0}}
     */
    public static Localizable _ResourceDomainConfiguration_IOException(Object arg0) {
        return new Localizable(holder, "ResourceDomainConfiguration.IOException", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedMonthsAgo}: {@code Last used over
     * {0} months ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used over {0} months ago}
     */
    public static String ApiTokenProperty_lastUsedMonthsAgo(Object arg0) {
        return holder.format("ApiTokenProperty.lastUsedMonthsAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedMonthsAgo}: {@code Last used over
     * {0} months ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used over {0} months ago}
     */
    public static Localizable _ApiTokenProperty_lastUsedMonthsAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.lastUsedMonthsAgo", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.SomeJenkins}: {@code The
     * specified URL points to a Jenkins instance, but could not determine
     * whether it is this or another instance.}.
     * 
     * @return
     *     {@code The specified URL points to a Jenkins instance, but could not
     *     determine whether it is this or another instance.}
     */
    public static String ResourceDomainConfiguration_SomeJenkins() {
        return holder.format("ResourceDomainConfiguration.SomeJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SomeJenkins}: {@code The
     * specified URL points to a Jenkins instance, but could not determine
     * whether it is this or another instance.}.
     * 
     * @return
     *     {@code The specified URL points to a Jenkins instance, but could not
     *     determine whether it is this or another instance.}
     */
    public static Localizable _ResourceDomainConfiguration_SomeJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.SomeJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Invalid}: {@code Not a valid
     * URL.}.
     * 
     * @return
     *     {@code Not a valid URL.}
     */
    public static String ResourceDomainConfiguration_Invalid() {
        return holder.format("ResourceDomainConfiguration.Invalid");
    }

    /**
     * Key {@code ResourceDomainConfiguration.Invalid}: {@code Not a valid
     * URL.}.
     * 
     * @return
     *     {@code Not a valid URL.}
     */
    public static Localizable _ResourceDomainConfiguration_Invalid() {
        return new Localizable(holder, "ResourceDomainConfiguration.Invalid");
    }

    /**
     * Key {@code ApiTokenProperty.createdYesterday}: {@code Created
     * yesterday}.
     * 
     * @return
     *     {@code Created yesterday}
     */
    public static String ApiTokenProperty_createdYesterday() {
        return holder.format("ApiTokenProperty.createdYesterday");
    }

    /**
     * Key {@code ApiTokenProperty.createdYesterday}: {@code Created
     * yesterday}.
     * 
     * @return
     *     {@code Created yesterday}
     */
    public static Localizable _ApiTokenProperty_createdYesterday() {
        return new Localizable(holder, "ApiTokenProperty.createdYesterday");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedAWeekAgo}: {@code Last used over a
     * week ago}.
     * 
     * @return
     *     {@code Last used over a week ago}
     */
    public static String ApiTokenProperty_lastUsedAWeekAgo() {
        return holder.format("ApiTokenProperty.lastUsedAWeekAgo");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedAWeekAgo}: {@code Last used over a
     * week ago}.
     * 
     * @return
     *     {@code Last used over a week ago}
     */
    public static Localizable _ApiTokenProperty_lastUsedAWeekAgo() {
        return new Localizable(holder, "ApiTokenProperty.lastUsedAWeekAgo");
    }

    /**
     * Key {@code ApiTokenProperty.createdAWeekAgo}: {@code Created over a
     * week ago}.
     * 
     * @return
     *     {@code Created over a week ago}
     */
    public static String ApiTokenProperty_createdAWeekAgo() {
        return holder.format("ApiTokenProperty.createdAWeekAgo");
    }

    /**
     * Key {@code ApiTokenProperty.createdAWeekAgo}: {@code Created over a
     * week ago}.
     * 
     * @return
     *     {@code Created over a week ago}
     */
    public static Localizable _ApiTokenProperty_createdAWeekAgo() {
        return new Localizable(holder, "ApiTokenProperty.createdAWeekAgo");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ResourceResponse}: {@code The
     * specified URL points to a previously set up resource root URL.}.
     * 
     * @return
     *     {@code The specified URL points to a previously set up resource root
     *     URL.}
     */
    public static String ResourceDomainConfiguration_ResourceResponse() {
        return holder.format("ResourceDomainConfiguration.ResourceResponse");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ResourceResponse}: {@code The
     * specified URL points to a previously set up resource root URL.}.
     * 
     * @return
     *     {@code The specified URL points to a previously set up resource root
     *     URL.}
     */
    public static Localizable _ResourceDomainConfiguration_ResourceResponse() {
        return new Localizable(holder, "ResourceDomainConfiguration.ResourceResponse");
    }

    /**
     * Key {@code ApiTokenProperty.DisplayName}: {@code API Token}.
     * 
     * @return
     *     {@code API Token}
     */
    public static String ApiTokenProperty_DisplayName() {
        return holder.format("ApiTokenProperty.DisplayName");
    }

    /**
     * Key {@code ApiTokenProperty.DisplayName}: {@code API Token}.
     * 
     * @return
     *     {@code API Token}
     */
    public static Localizable _ApiTokenProperty_DisplayName() {
        return new Localizable(holder, "ApiTokenProperty.DisplayName");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsJenkinsRoot}: {@code
     * Cannot use the same host name for both Jenkins URL and resource root
     * URL.}.
     * 
     * @return
     *     {@code Cannot use the same host name for both Jenkins URL and resource
     *     root URL.}
     */
    public static String ResourceDomainConfiguration_SameAsJenkinsRoot() {
        return holder.format("ResourceDomainConfiguration.SameAsJenkinsRoot");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsJenkinsRoot}: {@code
     * Cannot use the same host name for both Jenkins URL and resource root
     * URL.}.
     * 
     * @return
     *     {@code Cannot use the same host name for both Jenkins URL and resource
     *     root URL.}
     */
    public static Localizable _ResourceDomainConfiguration_SameAsJenkinsRoot() {
        return new Localizable(holder, "ResourceDomainConfiguration.SameAsJenkinsRoot");
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedDaysAgo}: {@code Last used {0}
     * days ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used {0} days ago}
     */
    public static String ApiTokenProperty_lastUsedDaysAgo(Object arg0) {
        return holder.format("ApiTokenProperty.lastUsedDaysAgo", arg0);
    }

    /**
     * Key {@code ApiTokenProperty.lastUsedDaysAgo}: {@code Last used {0}
     * days ago}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Last used {0} days ago}
     */
    public static Localizable _ApiTokenProperty_lastUsedDaysAgo(Object arg0) {
        return new Localizable(holder, "ApiTokenProperty.lastUsedDaysAgo", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsCurrent}: {@code You are
     * currently accessing Jenkins through a URL similar to the proposed
     * resource root URL. Saving this URL might remove your access to
     * Jenkins.}.
     * 
     * @return
     *     {@code You are currently accessing Jenkins through a URL similar to
     *     the proposed resource root URL. Saving this URL might remove your
     *     access to Jenkins.}
     */
    public static String ResourceDomainConfiguration_SameAsCurrent() {
        return holder.format("ResourceDomainConfiguration.SameAsCurrent");
    }

    /**
     * Key {@code ResourceDomainConfiguration.SameAsCurrent}: {@code You are
     * currently accessing Jenkins through a URL similar to the proposed
     * resource root URL. Saving this URL might remove your access to
     * Jenkins.}.
     * 
     * @return
     *     {@code You are currently accessing Jenkins through a URL similar to
     *     the proposed resource root URL. Saving this URL might remove your
     *     access to Jenkins.}
     */
    public static Localizable _ResourceDomainConfiguration_SameAsCurrent() {
        return new Localizable(holder, "ResourceDomainConfiguration.SameAsCurrent");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ThisJenkins}: {@code The
     * specified URL is a valid resource root URL candidate.}.
     * 
     * @return
     *     {@code The specified URL is a valid resource root URL candidate.}
     */
    public static String ResourceDomainConfiguration_ThisJenkins() {
        return holder.format("ResourceDomainConfiguration.ThisJenkins");
    }

    /**
     * Key {@code ResourceDomainConfiguration.ThisJenkins}: {@code The
     * specified URL is a valid resource root URL candidate.}.
     * 
     * @return
     *     {@code The specified URL is a valid resource root URL candidate.}
     */
    public static Localizable _ResourceDomainConfiguration_ThisJenkins() {
        return new Localizable(holder, "ResourceDomainConfiguration.ThisJenkins");
    }

    /**
     * Key {@code Token.Created.on}: {@code Token created on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Token created on {0}}
     */
    public static String Token_Created_on(Object arg0) {
        return holder.format("Token.Created.on", arg0);
    }

    /**
     * Key {@code Token.Created.on}: {@code Token created on {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Token created on {0}}
     */
    public static Localizable _Token_Created_on(Object arg0) {
        return new Localizable(holder, "Token.Created.on", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.Exception}: {@code An exception
     * occurred with the URL: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An exception occurred with the URL: {0}}
     */
    public static String ResourceDomainConfiguration_Exception(Object arg0) {
        return holder.format("ResourceDomainConfiguration.Exception", arg0);
    }

    /**
     * Key {@code ResourceDomainConfiguration.Exception}: {@code An exception
     * occurred with the URL: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code An exception occurred with the URL: {0}}
     */
    public static Localizable _ResourceDomainConfiguration_Exception(Object arg0) {
        return new Localizable(holder, "ResourceDomainConfiguration.Exception", arg0);
    }

}
