// CHECKSTYLE:OFF

package jenkins.security.apitoken;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code
     * ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.displayName}:
     * {@code Legacy API Token can be created even without existing}.
     * 
     * @return
     *     {@code Legacy API Token can be created even without existing}
     */
    public static String ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor_displayName() {
        return holder.format("ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.displayName");
    }

    /**
     * Key {@code
     * ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.displayName}:
     * {@code Legacy API Token can be created even without existing}.
     * 
     * @return
     *     {@code Legacy API Token can be created even without existing}
     */
    public static Localizable _ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor_displayName() {
        return new Localizable(holder, "ApiTokenPropertyEnabledNewLegacyAdministrativeMonitor.displayName");
    }

    /**
     * Key {@code LegacyApiTokenAdministrativeMonitor.displayName}: {@code
     * Legacy API Token usage}.
     * 
     * @return
     *     {@code Legacy API Token usage}
     */
    public static String LegacyApiTokenAdministrativeMonitor_displayName() {
        return holder.format("LegacyApiTokenAdministrativeMonitor.displayName");
    }

    /**
     * Key {@code LegacyApiTokenAdministrativeMonitor.displayName}: {@code
     * Legacy API Token usage}.
     * 
     * @return
     *     {@code Legacy API Token usage}
     */
    public static Localizable _LegacyApiTokenAdministrativeMonitor_displayName() {
        return new Localizable(holder, "LegacyApiTokenAdministrativeMonitor.displayName");
    }

    /**
     * Key {@code
     * ApiTokenPropertyDisabledDefaultAdministrativeMonitor.displayName}:
     * {@code Legacy API Token not generated by default}.
     * 
     * @return
     *     {@code Legacy API Token not generated by default}
     */
    public static String ApiTokenPropertyDisabledDefaultAdministrativeMonitor_displayName() {
        return holder.format("ApiTokenPropertyDisabledDefaultAdministrativeMonitor.displayName");
    }

    /**
     * Key {@code
     * ApiTokenPropertyDisabledDefaultAdministrativeMonitor.displayName}:
     * {@code Legacy API Token not generated by default}.
     * 
     * @return
     *     {@code Legacy API Token not generated by default}
     */
    public static Localizable _ApiTokenPropertyDisabledDefaultAdministrativeMonitor_displayName() {
        return new Localizable(holder, "ApiTokenPropertyDisabledDefaultAdministrativeMonitor.displayName");
    }

}
