/*
 * Decompiled with CFR 0.152.
 */
package hudson.console;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.console.ConsoleAnnotator;
import hudson.model.InvisibleAction;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.jvnet.tiger_types.Types;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;

public abstract class ConsoleAnnotatorFactory<T>
implements ExtensionPoint {
    public abstract ConsoleAnnotator<T> newInstance(T var1);

    public Class<?> type() {
        Type type = Types.getBaseClass(this.getClass(), ConsoleAnnotatorFactory.class);
        if (type instanceof ParameterizedType) {
            return Types.erasure((Type)Types.getTypeArgument((Type)type, (int)0));
        }
        return Object.class;
    }

    public boolean hasScript() {
        return this.getResource("/script.js") != null;
    }

    public boolean hasStylesheet() {
        return this.getResource("/style.css") != null;
    }

    private URL getResource(String fileName) {
        Class<?> c = this.getClass();
        return c.getClassLoader().getResource(c.getName().replace('.', '/').replace('$', '/') + fileName);
    }

    @WebMethod(name={"script.js"})
    public void doScriptJs(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        rsp.serveFile(req, this.getResource("/script.js"), TimeUnit.DAYS.toMillis(1L));
    }

    @WebMethod(name={"style.css"})
    public void doStyleCss(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        rsp.serveFile(req, this.getResource("/style.css"), TimeUnit.DAYS.toMillis(1L));
    }

    public static ExtensionList<ConsoleAnnotatorFactory> all() {
        return ExtensionList.lookup(ConsoleAnnotatorFactory.class);
    }

    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class RootAction
    extends InvisibleAction
    implements hudson.model.RootAction {
        @Override
        public String getUrlName() {
            return ConsoleAnnotatorFactory.class.getName();
        }

        public ConsoleAnnotatorFactory<?> getDynamic(String className) {
            return ConsoleAnnotatorFactory.all().getDynamic(className);
        }
    }
}

