/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ExtensionList;
import hudson.Util;
import hudson.model.AbstractModelObject;
import hudson.model.Messages;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import jenkins.model.Jenkins;
import jenkins.security.SecureRequester;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.util.xml.FilteredFunctionContext;
import org.dom4j.CharacterData;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.jaxen.FunctionContext;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.NamedPathPruner;
import org.kohsuke.stapler.export.SchemaGenerator;
import org.kohsuke.stapler.export.TreePruner;

public class Api
extends AbstractModelObject {
    public final Object bean;
    private static final Logger LOGGER = Logger.getLogger(Api.class.getName());
    private static final ModelBuilder MODEL_BUILDER = new ModelBuilder();

    public Api(Object bean) {
        this.bean = bean;
    }

    @Override
    public String getDisplayName() {
        return "API";
    }

    @Override
    public String getSearchUrl() {
        return "api";
    }

    public void doXml(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String xpath, @QueryParameter String wrapper, @QueryParameter String tree, @QueryParameter int depth) throws IOException, jakarta.servlet.ServletException {
        Object result;
        this.setHeaders(rsp);
        String[] excludes = req.getParameterValues("exclude");
        if (xpath == null && excludes == null) {
            rsp.serveExposedBean(req, this.bean, Flavor.XML);
            return;
        }
        StringWriter sw = new StringWriter();
        Model p = MODEL_BUILDER.get(this.bean.getClass());
        NamedPathPruner pruner = tree != null ? new NamedPathPruner(tree) : new TreePruner.ByDepth(1 - depth);
        p.writeTo(this.bean, (TreePruner)pruner, Flavor.XML.createDataWriter(this.bean, (Writer)sw));
        FilteredFunctionContext functionContext = new FilteredFunctionContext();
        try {
            Document dom = new SAXReader().read((Reader)new StringReader(sw.toString()));
            if (excludes != null) {
                for (String exclude : excludes) {
                    XPath xExclude = dom.createXPath(exclude);
                    xExclude.setFunctionContext((FunctionContext)functionContext);
                    List list = xExclude.selectNodes((Object)dom);
                    for (Node n : list) {
                        Element parent = n.getParent();
                        if (parent == null) continue;
                        parent.remove(n);
                    }
                }
            }
            if (xpath == null) {
                result = dom;
            } else {
                XPath comp = dom.createXPath(xpath);
                comp.setFunctionContext((FunctionContext)functionContext);
                List list = comp.selectNodes((Object)dom);
                if (wrapper != null) {
                    String validNameRE = "^[a-zA-Z_][\\w-\\.]*$";
                    if (!wrapper.matches(validNameRE)) {
                        rsp.setStatus(400);
                        rsp.getWriter().print(Messages.Api_WrapperParamInvalid());
                        return;
                    }
                    Element root = DocumentFactory.getInstance().createElement(wrapper);
                    for (Object o : list) {
                        if (o instanceof String) {
                            root.addText(o.toString());
                            continue;
                        }
                        root.add(((Node)o).detach());
                    }
                    result = root;
                } else {
                    if (list.isEmpty()) {
                        rsp.setStatus(404);
                        rsp.getWriter().print(Messages.Api_NoXPathMatch(xpath));
                        return;
                    }
                    if (list.size() > 1) {
                        rsp.setStatus(500);
                        rsp.getWriter().print(Messages.Api_MultipleMatch(xpath, list.size()));
                        return;
                    }
                    result = list.get(0);
                }
            }
        }
        catch (DocumentException e) {
            LOGGER.log(Level.FINER, "Failed to do XPath/wrapper handling. XML is as follows:" + String.valueOf(sw), e);
            throw new IOException("Failed to do XPath/wrapper handling. Turn on FINER logging to view XML.", e);
        }
        if (this.isSimpleOutput(result) && !this.permit(req)) {
            rsp.sendError(403, "primitive XPath result sets forbidden; implement jenkins.security.SecureRequester");
            return;
        }
        try (ServletOutputStream o = rsp.getOutputStream();){
            if (this.isSimpleOutput(result)) {
                rsp.setContentType("text/plain;charset=UTF-8");
                String text = result instanceof CharacterData ? ((CharacterData)result).getText() : result.toString();
                o.write(text.getBytes(StandardCharsets.UTF_8));
                return;
            }
            rsp.setContentType("application/xml;charset=UTF-8");
            new XMLWriter((OutputStream)o).write(result);
        }
    }

    private boolean isSimpleOutput(Object result) {
        return result instanceof CharacterData || result instanceof String || result instanceof Number || result instanceof Boolean;
    }

    public void doSchema(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        this.setHeaders(rsp);
        rsp.setContentType("application/xml");
        StreamResult r = new StreamResult((OutputStream)rsp.getOutputStream());
        new SchemaGenerator(new ModelBuilder().get(this.bean.getClass())).generateSchema((Result)r);
        r.getOutputStream().close();
    }

    public void doJson(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        if (Util.isOverridden(Api.class, this.getClass(), "doJson", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.doJson(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        } else {
            this.doJsonImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doJson(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            this.doJsonImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private void doJsonImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        if (req.getParameter("jsonp") == null || this.permit(req)) {
            this.setHeaders(rsp);
            rsp.serveExposedBean(req, this.bean, req.getParameter("jsonp") == null ? Flavor.JSON : Flavor.JSONP);
        } else {
            rsp.sendError(403, "jsonp forbidden; implement jenkins.security.SecureRequester");
        }
    }

    public void doPython(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        if (Util.isOverridden(Api.class, this.getClass(), "doPython", StaplerRequest.class, StaplerResponse.class)) {
            try {
                this.doPython(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp));
            }
            catch (ServletException e) {
                throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
            }
        } else {
            this.doPythonImpl(req, rsp);
        }
    }

    @Deprecated
    @StaplerNotDispatchable
    public void doPython(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        try {
            this.doPythonImpl(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp));
        }
        catch (jakarta.servlet.ServletException e) {
            throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
        }
    }

    private void doPythonImpl(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        this.setHeaders(rsp);
        rsp.serveExposedBean(req, this.bean, Flavor.PYTHON);
    }

    private boolean permit(StaplerRequest2 req) {
        for (SecureRequester r : ExtensionList.lookup(SecureRequester.class)) {
            if (!r.permit(req, this.bean)) continue;
            return true;
        }
        return false;
    }

    @Restricted(value={NoExternalUse.class})
    protected void setHeaders(StaplerResponse2 rsp) {
        rsp.setHeader("X-Jenkins", Jenkins.VERSION);
        rsp.setHeader("X-Jenkins-Session", Jenkins.SESSION_HASH);
        rsp.setHeader("X-Content-Type-Options", "nosniff");
        rsp.setHeader("X-Frame-Options", "deny");
    }
}

