/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import hudson.util.DelegatingClassLoader;
import java.util.Objects;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public final class ExistenceCheckingClassLoader
extends DelegatingClassLoader {
    public ExistenceCheckingClassLoader(String name, ClassLoader parent) {
        super(name, Objects.requireNonNull(parent));
    }

    public ExistenceCheckingClassLoader(ClassLoader parent) {
        super(Objects.requireNonNull(parent));
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.equals("java.lang.$JaCoCo")) {
            return super.loadClass(name, resolve);
        }
        if (this.getResource(name.replace('.', '/') + ".class") == null) {
            throw new ClassNotFoundException(name);
        }
        return super.loadClass(name, resolve);
    }
}

