/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model.queue;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Failure;
import hudson.model.Item;
import hudson.model.Messages;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.queue.Executables;
import hudson.model.queue.SubTask;
import hudson.model.queue.Tasks;
import hudson.model.queue.WorkUnit;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.jcip.annotations.GuardedBy;

@Extension
public class ItemDeletion
extends Queue.QueueDecisionHandler {
    private static final Logger LOGGER = Logger.getLogger(ItemDeletion.class.getName());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    @GuardedBy(value="lock")
    private final Set<Item> registrations = new HashSet<Item>();

    @GuardedBy(value="lock")
    private boolean _contains(@NonNull Item item) {
        if (this.registrations.isEmpty()) {
            return false;
        }
        while (item != null) {
            if (this.registrations.contains(item)) {
                return true;
            }
            if (!(item.getParent() instanceof Item)) break;
            item = (Item)((Object)item.getParent());
        }
        return false;
    }

    public static boolean contains(@NonNull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance == null) {
            return false;
        }
        instance.lock.readLock().lock();
        try {
            boolean bl = instance._contains(item);
            return bl;
        }
        finally {
            instance.lock.readLock().unlock();
        }
    }

    public static boolean isRegistered(@NonNull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance == null) {
            return false;
        }
        instance.lock.readLock().lock();
        try {
            boolean bl = instance.registrations.contains(item);
            return bl;
        }
        finally {
            instance.lock.readLock().unlock();
        }
    }

    public static boolean register(@NonNull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance == null) {
            return false;
        }
        instance.lock.writeLock().lock();
        try {
            boolean bl = instance.registrations.add(item);
            return bl;
        }
        finally {
            instance.lock.writeLock().unlock();
        }
    }

    public static void deregister(@NonNull Item item) {
        ItemDeletion instance = ItemDeletion.instance();
        if (instance != null) {
            instance.lock.writeLock().lock();
            try {
                instance.registrations.remove(item);
            }
            finally {
                instance.lock.writeLock().unlock();
            }
        }
    }

    @CheckForNull
    private static ItemDeletion instance() {
        return ExtensionList.lookup(Queue.QueueDecisionHandler.class).get(ItemDeletion.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shouldSchedule(Queue.Task p, List<Action> actions) {
        Item item = Tasks.getItemOf(p);
        if (item != null) {
            this.lock.readLock().lock();
            try {
                boolean bl = !this._contains(item);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
        return true;
    }

    public static void cancelBuildsInProgress(@NonNull Item initiatingItem) throws Failure, InterruptedException {
        Queue queue = Queue.getInstance();
        if (initiatingItem instanceof Queue.Task) {
            queue.cancel((Queue.Task)((Object)initiatingItem));
        }
        block0: for (Queue.Item i : queue.getItems()) {
            for (Item item = Tasks.getItemOf(i.task); item != null; item = (Item)((Object)item.getParent())) {
                if (item == initiatingItem) {
                    if (queue.cancel(i)) continue block0;
                    LOGGER.warning(() -> "failed to cancel " + String.valueOf(i));
                    continue block0;
                }
                if (!(item.getParent() instanceof Item)) continue block0;
            }
        }
        LinkedHashMap<Executor, Queue.Executable> buildsInProgress = new LinkedHashMap<Executor, Queue.Executable>();
        for (Computer c : Jenkins.get().getComputers()) {
            block3: for (Executor e : c.getAllExecutors()) {
                WorkUnit workUnit = e.getCurrentWorkUnit();
                Queue.Executable executable = workUnit != null ? workUnit.getExecutable() : null;
                SubTask subtask = executable != null ? Executables.getParentOf(executable) : null;
                if (subtask == null) continue;
                for (Item item = Tasks.getItemOf(subtask); item != null; item = (Item)((Object)item.getParent())) {
                    if (item == initiatingItem) {
                        buildsInProgress.put(e, e.getCurrentExecutable());
                        e.interrupt(Result.ABORTED);
                        continue block3;
                    }
                    if (!(item.getParent() instanceof Item)) continue block3;
                }
            }
        }
        if (!buildsInProgress.isEmpty()) {
            long expiration = System.nanoTime() + TimeUnit.SECONDS.toNanos(15L);
            while (!buildsInProgress.isEmpty() && expiration - System.nanoTime() > 0L) {
                Iterator iterator = buildsInProgress.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (((Executor)entry.getKey()).isActive() && entry.getValue() == ((Executor)entry.getKey()).getCurrentExecutable()) continue;
                    iterator.remove();
                }
                Thread.sleep(50L);
            }
            if (!buildsInProgress.isEmpty()) {
                throw new Failure(Messages.AbstractItem_FailureToStopBuilds(buildsInProgress.size(), initiatingItem.getFullDisplayName()));
            }
        }
    }
}

