/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.VersionNumber;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import jenkins.model.Jenkins;
import jenkins.telemetry.Telemetry;
import jenkins.util.SystemProperties;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class SecuritySystemProperties
extends Telemetry {
    @Override
    @NonNull
    public String getId() {
        return "security-system-properties";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2018, 9, 1);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2018, 12, 1);
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Use of Security-related Java system properties";
    }

    @Override
    @NonNull
    public JSONObject createContent() {
        TreeMap<String, String> security = new TreeMap<String, String>();
        SecuritySystemProperties.putBoolean(security, "hudson.ConsoleNote.INSECURE", false);
        SecuritySystemProperties.putBoolean(security, "hudson.logging.LogRecorderManager.skipPermissionCheck", false);
        SecuritySystemProperties.putBoolean(security, "hudson.model.AbstractItem.skipPermissionCheck", false);
        SecuritySystemProperties.putBoolean(security, "hudson.model.ParametersAction.keepUndefinedParameters", false);
        SecuritySystemProperties.putBoolean(security, "hudson.model.Run.skipPermissionCheck", false);
        SecuritySystemProperties.putBoolean(security, "hudson.model.UpdateCenter.skipPermissionCheck", false);
        SecuritySystemProperties.putBoolean(security, "hudson.model.User.allowNonExistentUserToLogin", false);
        SecuritySystemProperties.putBoolean(security, "hudson.model.User.allowUserCreationViaUrl", false);
        SecuritySystemProperties.putBoolean(security, "hudson.model.User.SECURITY_243_FULL_DEFENSE", true);
        SecuritySystemProperties.putBoolean(security, "hudson.model.User.skipPermissionCheck", false);
        SecuritySystemProperties.putBoolean(security, "hudson.PluginManager.skipPermissionCheck", false);
        SecuritySystemProperties.putBoolean(security, "hudson.remoting.URLDeserializationHelper.avoidUrlWrapping", false);
        SecuritySystemProperties.putBoolean(security, "hudson.search.Search.skipPermissionCheck", false);
        SecuritySystemProperties.putBoolean(security, "jenkins.security.ClassFilterImpl.SUPPRESS_WHITELIST", false);
        SecuritySystemProperties.putBoolean(security, "jenkins.security.ClassFilterImpl.SUPPRESS_ALL", false);
        SecuritySystemProperties.putBoolean(security, "org.kohsuke.stapler.Facet.allowViewNamePathTraversal", false);
        SecuritySystemProperties.putBoolean(security, "org.kohsuke.stapler.jelly.CustomJellyContext.escapeByDefault", true);
        SecuritySystemProperties.putStringInfo(security, "hudson.model.ParametersAction.safeParameters");
        SecuritySystemProperties.putStringInfo(security, "hudson.model.DirectoryBrowserSupport.CSP");
        SecuritySystemProperties.putStringInfo(security, "hudson.security.HudsonPrivateSecurityRealm.ID_REGEX");
        TreeMap<String, Object> info = new TreeMap<String, Object>();
        VersionNumber jenkinsVersion = Jenkins.getVersion();
        info.put("core", jenkinsVersion != null ? jenkinsVersion.toString() : "UNKNOWN");
        info.put("clientDate", SecuritySystemProperties.clientDateString());
        info.put("properties", security);
        return JSONObject.fromObject(info);
    }

    private static String clientDateString() {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        df.setTimeZone(tz);
        return df.format(new Date());
    }

    private static void putBoolean(Map<String, String> propertiesMap, String systemProperty, boolean defaultValue) {
        propertiesMap.put(systemProperty, Boolean.toString(SystemProperties.getBoolean(systemProperty, defaultValue)));
    }

    private static void putStringInfo(Map<String, String> propertiesMap, String systemProperty) {
        String reportedValue = "null";
        String value = SystemProperties.getString(systemProperty);
        if (value != null) {
            reportedValue = Integer.toString(value.length());
        }
        propertiesMap.put(systemProperty, reportedValue);
    }
}

