/*
 * Decompiled with CFR 0.152.
 */
package jenkins.telemetry.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import jenkins.telemetry.Telemetry;
import jenkins.util.HttpServletFilter;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
public class UserLanguages
extends Telemetry {
    private static final Map<String, AtomicLong> requestsByLanguage = new ConcurrentSkipListMap<String, AtomicLong>();
    private static Logger LOGGER = Logger.getLogger(UserLanguages.class.getName());

    @Override
    @NonNull
    public String getId() {
        return UserLanguages.class.getName();
    }

    @Override
    @NonNull
    public String getDisplayName() {
        return "Browser languages";
    }

    @Override
    @NonNull
    public LocalDate getStart() {
        return LocalDate.of(2018, 10, 1);
    }

    @Override
    @NonNull
    public LocalDate getEnd() {
        return LocalDate.of(2019, 1, 1);
    }

    @Override
    public JSONObject createContent() {
        if (requestsByLanguage.isEmpty()) {
            return null;
        }
        TreeMap<String, AtomicLong> currentRequests = new TreeMap<String, AtomicLong>(requestsByLanguage);
        requestsByLanguage.clear();
        JSONObject payload = new JSONObject();
        for (Map.Entry entry : currentRequests.entrySet()) {
            payload.put((String)entry.getKey(), (Object)((AtomicLong)entry.getValue()).longValue());
        }
        return payload;
    }

    @Extension
    public static final class AcceptLanguageFilter
    implements HttpServletFilter {
        @Override
        public boolean handle(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
            String language;
            if (!Telemetry.isDisabled() && (language = req.getHeader("Accept-Language")) != null) {
                if (!requestsByLanguage.containsKey(language)) {
                    requestsByLanguage.put(language, new AtomicLong(0L));
                }
                requestsByLanguage.get(language).incrementAndGet();
            }
            return false;
        }
    }
}

