/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.slaves.ComputerListener;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.io.OnMaster;
import org.jenkinsci.remoting.util.DurationStyle;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="Currently Jenkins instance may have one ond only one context")
public class SystemProperties {
    private static final Handler NULL_HANDLER;
    @SuppressFBWarnings(value={"NP_NONNULL_FIELD_NOT_INITIALIZED_IN_CONSTRUCTOR"}, justification="the field is initialized by a static initializer, not a constructor")
    @NonNull
    private static Handler handler;
    private static final Set<String> ALLOW_ON_AGENT;
    private static final Logger LOGGER;

    public static void allowOnAgent(String key) {
        ALLOW_ON_AGENT.add(key);
    }

    private SystemProperties() {
    }

    @CheckForNull
    public static String getString(String key) {
        return SystemProperties.getString(key, null);
    }

    public static String getString(String key, @CheckForNull String def) {
        return SystemProperties.getString(key, def, Level.CONFIG);
    }

    public static String getString(String key, @CheckForNull String def, Level logLevel) {
        String value = System.getProperty(key);
        if (value != null) {
            if (LOGGER.isLoggable(logLevel)) {
                LOGGER.log(logLevel, "Property (system): {0} => {1}", new Object[]{key, value});
            }
            return value;
        }
        value = handler.getString(key);
        if (value != null) {
            if (LOGGER.isLoggable(logLevel)) {
                LOGGER.log(logLevel, "Property (context): {0} => {1}", new Object[]{key, value});
            }
            return value;
        }
        value = def;
        if (LOGGER.isLoggable(logLevel)) {
            LOGGER.log(logLevel, "Property (default): {0} => {1}", new Object[]{key, value});
        }
        return value;
    }

    public static boolean getBoolean(String name) {
        return SystemProperties.getBoolean(name, false);
    }

    public static boolean getBoolean(String name, boolean def) {
        String v = SystemProperties.getString(name);
        if (v != null) {
            return Boolean.parseBoolean(v);
        }
        return def;
    }

    @CheckForNull
    public static Boolean optBoolean(String name) {
        String v = SystemProperties.getString(name);
        return v == null ? null : Boolean.valueOf(Boolean.parseBoolean(v));
    }

    @CheckForNull
    public static Duration getDuration(@NonNull String name) {
        return SystemProperties.getDuration(name, (Duration)null);
    }

    @CheckForNull
    public static Duration getDuration(@NonNull String name, @CheckForNull ChronoUnit unit) {
        return SystemProperties.getDuration(name, unit, null);
    }

    @Nullable
    public static Duration getDuration(@NonNull String name, @CheckForNull Duration defaultValue) {
        return SystemProperties.getDuration(name, null, defaultValue);
    }

    @Nullable
    public static Duration getDuration(@NonNull String name, @CheckForNull ChronoUnit unit, @CheckForNull Duration defaultValue) {
        String v = SystemProperties.getString(name);
        if (v != null) {
            try {
                return DurationStyle.detectAndParse((String)v, (ChronoUnit)unit);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, e, () -> "Failed to convert \"%s\" to a valid duration for property \"%s\", falling back to default \"%s\"".formatted(v, name, defaultValue));
            }
        }
        return defaultValue;
    }

    @CheckForNull
    public static Integer getInteger(String name) {
        return SystemProperties.getInteger(name, null);
    }

    public static Integer getInteger(String name, Integer def) {
        return SystemProperties.getInteger(name, def, Level.CONFIG);
    }

    public static Integer getInteger(String name, Integer def, Level logLevel) {
        block3: {
            String v = SystemProperties.getString(name);
            if (v != null) {
                try {
                    return Integer.decode(v);
                }
                catch (NumberFormatException e) {
                    if (!LOGGER.isLoggable(logLevel)) break block3;
                    LOGGER.log(logLevel, "Property. Value is not integer: {0} => {1}", new Object[]{name, v});
                }
            }
        }
        return def;
    }

    @CheckForNull
    public static Long getLong(String name) {
        return SystemProperties.getLong(name, null);
    }

    public static Long getLong(String name, Long def) {
        return SystemProperties.getLong(name, def, Level.CONFIG);
    }

    public static Long getLong(String name, Long def, Level logLevel) {
        block3: {
            String v = SystemProperties.getString(name);
            if (v != null) {
                try {
                    return Long.decode(v);
                }
                catch (NumberFormatException e) {
                    if (!LOGGER.isLoggable(logLevel)) break block3;
                    LOGGER.log(logLevel, "Property. Value is not long: {0} => {1}", new Object[]{name, v});
                }
            }
        }
        return def;
    }

    static {
        handler = NULL_HANDLER = key -> null;
        ALLOW_ON_AGENT = Collections.synchronizedSet(new HashSet());
        LOGGER = Logger.getLogger(SystemProperties.class.getName());
    }

    @FunctionalInterface
    private static interface Handler {
        @CheckForNull
        public String getString(String var1);
    }

    @Extension
    @Restricted(value={NoExternalUse.class})
    public static final class AgentCopier
    extends ComputerListener {
        @Override
        public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) throws IOException, InterruptedException {
            channel.call((Callable)new CopySystemProperties());
        }

        private static final class CopySystemProperties
        extends MasterToSlaveCallable<Void, RuntimeException> {
            private static final long serialVersionUID = 1L;
            private final Map<String, String> snapshot = new HashMap<String, String>();

            CopySystemProperties() {
                for (String key : ALLOW_ON_AGENT) {
                    this.snapshot.put(key, SystemProperties.getString(key));
                }
                LOGGER.log(Level.FINE, "taking snapshot of {0}", this.snapshot);
            }

            public Void call() throws RuntimeException {
                handler = new CopiedHandler(this.snapshot);
                return null;
            }
        }

        private static final class CopiedHandler
        implements Handler {
            private final Map<String, String> snapshot;

            CopiedHandler(Map<String, String> snapshot) {
                this.snapshot = snapshot;
            }

            @Override
            public String getString(String key) {
                return this.snapshot.get(key);
            }
        }
    }

    @Restricted(value={NoExternalUse.class})
    public static final class Listener
    implements ServletContextListener,
    OnMaster {
        public void contextInitialized(ServletContextEvent event) {
            ServletContext theContext = event.getServletContext();
            handler = key -> {
                if (key != null && !key.isBlank()) {
                    try {
                        return theContext.getInitParameter(key);
                    }
                    catch (SecurityException ex) {
                        LOGGER.log(Level.CONFIG, "Access to the property {0} is prohibited", key);
                    }
                }
                return null;
            };
        }

        public void contextDestroyed(ServletContextEvent event) {
            handler = NULL_HANDLER;
        }
    }
}

