/*
 * Decompiled with CFR 0.152.
 */
package jenkins.diagnostics;

import hudson.Extension;
import hudson.init.InitMilestone;
import hudson.model.AdministrativeMonitor;
import jenkins.diagnostics.Messages;
import jenkins.health.HealthCheck;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@Extension
@Symbol(value={"completedInitialization"})
public class CompletedInitializationMonitor
extends AdministrativeMonitor {
    @Override
    public String getDisplayName() {
        return Messages.CompletedInitializationMonitor_DisplayName();
    }

    @Override
    public boolean isActivated() {
        return !CompletedInitializationMonitor.isInitCompleted();
    }

    private static boolean isInitCompleted() {
        Jenkins instance = Jenkins.get();
        return instance.getInitLevel() == InitMilestone.COMPLETED;
    }

    @Extension
    public static final class HealthCheckImpl
    implements HealthCheck {
        @Override
        public String getName() {
            return "completedInitialization";
        }

        @Override
        public boolean check() {
            return CompletedInitializationMonitor.isInitCompleted();
        }
    }
}

