/*
 * Decompiled with CFR 0.152.
 */
package jenkins.model;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.cli.declarative.CLIMethod;
import hudson.cli.declarative.CLIResolver;
import hudson.model.AbstractItem;
import hudson.model.Action;
import hudson.model.BuildAuthorizationToken;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.listeners.ItemListener;
import hudson.model.queue.QueueTaskFuture;
import hudson.search.SearchIndexBuilder;
import hudson.triggers.Trigger;
import hudson.util.AlternativeUiTextProvider;
import io.jenkins.servlet.ServletExceptionWrapper;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import jenkins.model.Messages;
import jenkins.model.lazy.LazyBuildMixIn;
import jenkins.security.stapler.StaplerNotDispatchable;
import jenkins.triggers.SCMTriggerItem;
import jenkins.triggers.TriggeredItem;
import jenkins.util.TimeDuration;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.accmod.restrictions.ProtectedExternally;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.HttpResponses;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public abstract class ParameterizedJobMixIn<JobT extends Job<JobT, RunT> & Queue.Task, RunT extends Run<JobT, RunT>> {
    public static final AlternativeUiTextProvider.Message<ParameterizedJob> BUILD_NOW_TEXT = new AlternativeUiTextProvider.Message();
    public static final AlternativeUiTextProvider.Message<ParameterizedJob> BUILD_WITH_PARAMETERS_TEXT = new AlternativeUiTextProvider.Message();

    protected abstract JobT asJob();

    public final boolean scheduleBuild() {
        return this.scheduleBuild(((ParameterizedJob)this.asJob()).getQuietPeriod(), new Cause.LegacyCodeCause());
    }

    public final boolean scheduleBuild(Cause c) {
        return this.scheduleBuild(((ParameterizedJob)this.asJob()).getQuietPeriod(), c);
    }

    public final boolean scheduleBuild(int quietPeriod) {
        return this.scheduleBuild(quietPeriod, new Cause.LegacyCodeCause());
    }

    public final boolean scheduleBuild(int quietPeriod, Cause c) {
        return this.scheduleBuild2(quietPeriod, c != null ? List.of(new CauseAction(c)) : Collections.emptyList()) != null;
    }

    @CheckForNull
    public final QueueTaskFuture<RunT> scheduleBuild2(int quietPeriod, Action ... actions) {
        Queue.Item i = this.scheduleBuild2(quietPeriod, Arrays.asList(actions));
        return i != null ? i.getFuture() : null;
    }

    @CheckForNull
    public static Queue.Item scheduleBuild2(final Job<?, ?> job, int quietPeriod, Action ... actions) {
        if (!(job instanceof ParameterizedJob)) {
            return null;
        }
        return new ParameterizedJobMixIn(){

            protected Job asJob() {
                return job;
            }
        }.scheduleBuild2(quietPeriod == -1 ? ((ParameterizedJob)((Object)job)).getQuietPeriod() : quietPeriod, Arrays.asList(actions));
    }

    @CheckForNull
    Queue.Item scheduleBuild2(int quietPeriod, List<Action> actions) {
        if (!((ParameterizedJob)this.asJob()).isBuildable()) {
            return null;
        }
        ArrayList<Action> queueActions = new ArrayList<Action>(actions);
        if (this.isParameterized() && Util.filter(queueActions, ParametersAction.class).isEmpty()) {
            queueActions.add(new ParametersAction(this.getDefaultParametersValues()));
        }
        return Jenkins.get().getQueue().schedule2((Queue.Task)this.asJob(), quietPeriod, queueActions).getItem();
    }

    private List<ParameterValue> getDefaultParametersValues() {
        ParametersDefinitionProperty paramDefProp = ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class);
        ArrayList<ParameterValue> defValues = new ArrayList<ParameterValue>();
        if (paramDefProp == null) {
            return defValues;
        }
        for (ParameterDefinition paramDefinition : paramDefProp.getParameterDefinitions()) {
            ParameterValue defaultValue = paramDefinition.getDefaultParameterValue();
            if (defaultValue == null) continue;
            defValues.add(defaultValue);
        }
        return defValues;
    }

    public final boolean isParameterized() {
        return ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class) != null;
    }

    public final void doBuild(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter TimeDuration delay) throws IOException, jakarta.servlet.ServletException {
        if (delay == null) {
            delay = new TimeDuration(TimeUnit.MILLISECONDS.convert(((ParameterizedJob)this.asJob()).getQuietPeriod(), TimeUnit.SECONDS));
        }
        if (!((ParameterizedJob)this.asJob()).isBuildable()) {
            throw HttpResponses.errorWithoutStack((int)409, (String)(((AbstractItem)this.asJob()).getFullName() + " is not buildable"));
        }
        ParametersDefinitionProperty pp = ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class);
        if (pp != null && !req.getMethod().equals("POST")) {
            req.getView((Object)pp, "index.jelly").forward((ServletRequest)req, (ServletResponse)rsp);
            return;
        }
        BuildAuthorizationToken.checkPermission(this.asJob(), ((ParameterizedJob)this.asJob()).getAuthToken(), req, rsp);
        if (pp != null) {
            pp._doBuild(req, rsp, delay);
            return;
        }
        Queue.Item item = Jenkins.get().getQueue().schedule2((Queue.Task)this.asJob(), delay.getTimeInSeconds(), ParameterizedJobMixIn.getBuildCause((ParameterizedJob)this.asJob(), req)).getItem();
        if (item != null) {
            rsp.sendRedirect(201, req.getContextPath() + "/" + item.getUrl());
        } else {
            rsp.sendRedirect(".");
        }
    }

    public final void doBuildWithParameters(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter TimeDuration delay) throws IOException, jakarta.servlet.ServletException {
        BuildAuthorizationToken.checkPermission(this.asJob(), ((ParameterizedJob)this.asJob()).getAuthToken(), req, rsp);
        ParametersDefinitionProperty pp = ((Job)this.asJob()).getProperty(ParametersDefinitionProperty.class);
        if (!((ParameterizedJob)this.asJob()).isBuildable()) {
            throw HttpResponses.errorWithoutStack((int)409, (String)(((AbstractItem)this.asJob()).getFullName() + " is not buildable"));
        }
        if (pp == null) {
            throw HttpResponses.errorWithoutStack((int)400, (String)(((AbstractItem)this.asJob()).getFullName() + " is not parameterized"));
        }
        pp.buildWithParameters(req, rsp, delay);
    }

    @RequirePOST
    public final void doCancelQueue(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
        this.asJob().checkPermission(Item.CANCEL);
        Jenkins.get().getQueue().cancel((Queue.Task)this.asJob());
        rsp.forwardToPreviousPage(req);
    }

    public final SearchIndexBuilder extendSearchIndex(SearchIndexBuilder sib) {
        if (((ParameterizedJob)this.asJob()).isBuildable() && this.asJob().hasPermission(Item.BUILD)) {
            sib.add("build", "build");
        }
        return sib;
    }

    @Restricted(value={NoExternalUse.class})
    public static CauseAction getBuildCause(ParameterizedJob job, StaplerRequest2 req) {
        Cause cause;
        BuildAuthorizationToken authToken = job.getAuthToken();
        if (authToken != null && authToken.getToken() != null && req.getParameter("token") != null) {
            String causeText = req.getParameter("cause");
            cause = new Cause.RemoteCause(req.getRemoteAddr(), causeText);
        } else {
            cause = new Cause.UserIdCause();
        }
        return new CauseAction(cause);
    }

    public final String getBuildNowText() {
        return this.isParameterized() ? AlternativeUiTextProvider.get(BUILD_WITH_PARAMETERS_TEXT, (ParameterizedJob)this.asJob(), AlternativeUiTextProvider.get(BUILD_NOW_TEXT, (ParameterizedJob)this.asJob(), Messages.ParameterizedJobMixIn_build_with_parameters())) : AlternativeUiTextProvider.get(BUILD_NOW_TEXT, (ParameterizedJob)this.asJob(), Messages.ParameterizedJobMixIn_build_now());
    }

    @CheckForNull
    public static <T extends Trigger<?>> T getTrigger(Job<?, ?> job, Class<T> clazz) {
        if (!(job instanceof ParameterizedJob)) {
            return null;
        }
        for (Trigger<?> t : ((ParameterizedJob)((Object)job)).getTriggers().values()) {
            if (!clazz.isInstance(t)) continue;
            return (T)((Trigger)clazz.cast(t));
        }
        return null;
    }

    public static interface ParameterizedJob<JobT extends Job<JobT, RunT> & Queue.Task, RunT extends Run<JobT, RunT>>
    extends BuildableItem,
    TriggeredItem {
        @Restricted(value={DoNotUse.class})
        @CLIResolver
        public static ParameterizedJob resolveForCLI(@Argument(required=true, metaVar="NAME", usage="Job name") String name) throws CmdLineException {
            ParameterizedJob item = Jenkins.get().getItemByFullName(name, ParameterizedJob.class);
            if (item == null) {
                ParameterizedJob project = Items.findNearest(ParameterizedJob.class, name, Jenkins.get());
                throw new CmdLineException(null, project == null ? hudson.model.Messages.AbstractItem_NoSuchJobExistsWithoutSuggestion(name) : hudson.model.Messages.AbstractItem_NoSuchJobExists(name, project.getFullName()));
            }
            return item;
        }

        default public ParameterizedJobMixIn<JobT, RunT> getParameterizedJobMixIn() {
            return new ParameterizedJobMixIn<JobT, RunT>(){

                @Override
                protected JobT asJob() {
                    return (Job)((Object)this);
                }
            };
        }

        @CheckForNull
        public BuildAuthorizationToken getAuthToken();

        default public int getQuietPeriod() {
            return Jenkins.get().getQuietPeriod();
        }

        default public String getBuildNowText() {
            return this.getParameterizedJobMixIn().getBuildNowText();
        }

        @Override
        default public boolean scheduleBuild(Cause c) {
            return this.getParameterizedJobMixIn().scheduleBuild(c);
        }

        @Override
        default public boolean scheduleBuild(int quietPeriod, Cause c) {
            return this.getParameterizedJobMixIn().scheduleBuild(quietPeriod, c);
        }

        @CheckForNull
        default public QueueTaskFuture<RunT> scheduleBuild2(int quietPeriod, Action ... actions) {
            return this.getParameterizedJobMixIn().scheduleBuild2(quietPeriod, actions);
        }

        default public void doBuild(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter TimeDuration delay) throws IOException, jakarta.servlet.ServletException {
            if (Util.isOverridden(ParameterizedJob.class, this.getClass(), "doBuild", StaplerRequest.class, StaplerResponse.class, TimeDuration.class)) {
                try {
                    this.doBuild(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp), delay);
                }
                catch (ServletException e) {
                    throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
                }
            } else {
                this.getParameterizedJobMixIn().doBuild(req, rsp, delay);
            }
        }

        @Deprecated
        @StaplerNotDispatchable
        default public void doBuild(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
            try {
                this.getParameterizedJobMixIn().doBuild(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp), delay);
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
            }
        }

        default public void doBuildWithParameters(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter TimeDuration delay) throws IOException, jakarta.servlet.ServletException {
            if (Util.isOverridden(ParameterizedJob.class, this.getClass(), "doBuildWithParameters", StaplerRequest.class, StaplerResponse.class, TimeDuration.class)) {
                try {
                    this.doBuildWithParameters(StaplerRequest.fromStaplerRequest2((StaplerRequest2)req), StaplerResponse.fromStaplerResponse2((StaplerResponse2)rsp), delay);
                }
                catch (ServletException e) {
                    throw ServletExceptionWrapper.toJakartaServletException((ServletException)e);
                }
            } else {
                this.getParameterizedJobMixIn().doBuildWithParameters(req, rsp, delay);
            }
        }

        @Deprecated
        @StaplerNotDispatchable
        default public void doBuildWithParameters(StaplerRequest req, StaplerResponse rsp, @QueryParameter TimeDuration delay) throws IOException, ServletException {
            try {
                this.getParameterizedJobMixIn().doBuildWithParameters(StaplerRequest.toStaplerRequest2((StaplerRequest)req), StaplerResponse.toStaplerResponse2((StaplerResponse)rsp), delay);
            }
            catch (jakarta.servlet.ServletException e) {
                throw ServletExceptionWrapper.fromJakartaServletException((jakarta.servlet.ServletException)e);
            }
        }

        @RequirePOST
        default public void doCancelQueue(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
            this.getParameterizedJobMixIn().doCancelQueue(req, rsp);
        }

        default public void doPolling(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, jakarta.servlet.ServletException {
            if (!(this instanceof SCMTriggerItem)) {
                rsp.sendError(404);
                return;
            }
            BuildAuthorizationToken.checkPermission((Job)((Object)this), this.getAuthToken(), req, rsp);
            ((SCMTriggerItem)((Object)this)).schedulePolling();
            rsp.sendRedirect(".");
        }

        default public boolean isParameterized() {
            return this.getParameterizedJobMixIn().isParameterized();
        }

        default public boolean isDisabled() {
            return false;
        }

        @Restricted(value={ProtectedExternally.class})
        default public void setDisabled(boolean disabled) {
            throw new UnsupportedOperationException("must be implemented if supportsMakeDisabled is overridden");
        }

        default public boolean supportsMakeDisabled() {
            return false;
        }

        default public void makeDisabled(boolean b) throws IOException {
            if (this.isDisabled() == b) {
                return;
            }
            if (b && !this.supportsMakeDisabled()) {
                return;
            }
            this.setDisabled(b);
            if (b) {
                Jenkins.get().getQueue().cancel(this);
            }
            this.save();
            ItemListener.fireOnUpdated(this);
        }

        @CLIMethod(name="disable-job")
        @RequirePOST
        default public HttpResponse doDisable() throws IOException {
            this.checkPermission(CONFIGURE);
            this.makeDisabled(true);
            return new HttpRedirect(".");
        }

        @CLIMethod(name="enable-job")
        @RequirePOST
        default public HttpResponse doEnable() throws IOException {
            this.checkPermission(CONFIGURE);
            this.makeDisabled(false);
            return new HttpRedirect(".");
        }

        default public RunT createExecutable() throws IOException {
            if (this.isDisabled()) {
                return null;
            }
            if (this instanceof LazyBuildMixIn.LazyLoadingJob) {
                return ((LazyBuildMixIn.LazyLoadingJob)((Object)this)).getLazyBuildMixIn().newBuild();
            }
            return null;
        }

        default public boolean isBuildable() {
            return !this.isDisabled() && !((Job)((Object)this)).isHoldOffBuildUntilSave();
        }
    }
}

