/*
 * Decompiled with CFR 0.152.
 */
package jenkins.slaves;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Channel;
import hudson.remoting.StandardOutputStream;
import hudson.slaves.ComputerListener;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.MasterToSlaveCallable;
import jenkins.util.SystemProperties;

@Extension
public class StandardOutputSwapper
extends ComputerListener {
    private static final Logger LOGGER = Logger.getLogger(StandardOutputSwapper.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Accessible via System Groovy Scripts")
    public static boolean disabled = SystemProperties.getBoolean(StandardOutputSwapper.class.getName() + ".disabled");

    @Override
    public void preOnline(Computer c, Channel channel, FilePath root, TaskListener listener) {
        if (disabled) {
            return;
        }
        try {
            if (((Boolean)channel.call((Callable)new ChannelSwapper())).booleanValue()) {
                listener.getLogger().println("Evacuated stdout");
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.FINE, "Fatal problem swapping file descriptors " + c.getName(), x);
        }
    }

    private static final class ChannelSwapper
    extends MasterToSlaveCallable<Boolean, Exception> {
        private ChannelSwapper() {
        }

        public Boolean call() throws Exception {
            if (File.pathSeparatorChar == ';') {
                return false;
            }
            Channel c = this.getOpenChannelOrFail();
            StandardOutputStream sos = (StandardOutputStream)c.getProperty(StandardOutputStream.class);
            if (sos != null) {
                this._swap(sos);
                return true;
            }
            OutputStream o = c.getUnderlyingOutput();
            if (o instanceof StandardOutputStream) {
                this._swap((StandardOutputStream)o);
                return true;
            }
            return false;
        }

        private void _swap(StandardOutputStream stdout) throws Exception {
            try {
                this.swap(stdout);
            }
            catch (LinkageError x) {
                throw new Exception(x);
            }
        }

        @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="the obligation is satisfied with libc(7)")
        private void swap(StandardOutputStream stdout) throws IOException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, UnsatisfiedLinkError {
            int out = GNUCLibrary.LIBC.dup(1);
            if (out < 0) {
                throw new IOException("Failed to dup(1)");
            }
            Constructor c = FileDescriptor.class.getDeclaredConstructor(Integer.TYPE);
            c.setAccessible(true);
            FileOutputStream fos = new FileOutputStream((FileDescriptor)c.newInstance(out));
            stdout.swap((OutputStream)fos);
            GNUCLibrary.LIBC.close(1);
            GNUCLibrary.LIBC.dup2(2, 1);
        }
    }
}

