/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import jenkins.util.JenkinsClassLoader;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class URLClassLoader2
extends URLClassLoader
implements JenkinsClassLoader {
    private static final AtomicInteger NEXT_INSTANCE_NUMBER = new AtomicInteger(0);
    private final String lockObjectPrefixName = String.format("%s@%x-loadClassLock:", URLClassLoader2.class.getName(), NEXT_INSTANCE_NUMBER.getAndIncrement());

    @Deprecated(since="2.459")
    public URLClassLoader2(URL[] urls) {
        super(urls);
    }

    @Deprecated(since="2.459")
    public URLClassLoader2(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public URLClassLoader2(String name, URL[] urls) {
        super(name, urls, URLClassLoader2.getSystemClassLoader());
    }

    public URLClassLoader2(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        return super.findClass(name);
    }

    @Override
    public Class<?> findLoadedClass2(String name) {
        return super.findLoadedClass(name);
    }

    @Override
    public Object getClassLoadingLock(String className) {
        Objects.requireNonNull(className);
        return (this.lockObjectPrefixName + className).intern();
    }

    static {
        URLClassLoader2.registerAsParallelCapable();
    }
}

