/*
 * Decompiled with CFR 0.152.
 */
package jenkins.util;

import jenkins.org.apache.commons.validator.routines.DomainValidator;
import jenkins.org.apache.commons.validator.routines.UrlValidator;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class UrlHelper {
    private static String DOMAIN_REGEX = System.getProperty(UrlHelper.class.getName() + ".DOMAIN_REGEX", "^\\w(-*(\\.|\\w))*\\.*(:\\d{1,5})?$");

    public static boolean isValidRootUrl(String url) {
        CustomUrlValidator validator = new CustomUrlValidator();
        return validator.isValid(url);
    }

    private static class CustomUrlValidator
    extends UrlValidator {
        private CustomUrlValidator() {
            super(new String[]{"http", "https"}, 12L);
        }

        @Override
        protected boolean isValidAuthority(String authority) {
            boolean superResult = super.isValidAuthority(authority);
            if (superResult && authority.contains("[")) {
                return true;
            }
            if (!superResult && authority == null) {
                return false;
            }
            String authorityASCII = DomainValidator.unicodeToASCII(authority);
            return authorityASCII.matches(DOMAIN_REGEX);
        }

        @Override
        protected boolean isValidQuery(String query) {
            return query == null;
        }
    }
}

