/*
 * Decompiled with CFR 0.152.
 */
package hudson;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.xml.XppDriver;
import hudson.Util;
import hudson.util.AtomicFileWriter;
import hudson.util.XStream2;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParserFactory;

public final class XmlFile {
    private final XStream xs;
    private final File file;
    private static final XStream DEFAULT_XSTREAM = new XStream2();
    private static final Logger LOGGER = Logger.getLogger(XmlFile.class.getName());
    private static final SAXParserFactory JAXP = SAXParserFactory.newInstance();
    private static final XppDriver DEFAULT_DRIVER = new XppDriver();

    public XmlFile(File file) {
        this(DEFAULT_XSTREAM, file);
    }

    public XmlFile(XStream xs, File file) {
        this.xs = xs;
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    public XStream getXStream() {
        return this.xs;
    }

    public Object read() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Reading " + this.file);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            Object object = this.xs.fromXML((InputStream)in);
            return object;
        }
    }

    public Object unmarshal(Object o) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.file));){
            Object object = this.xs.unmarshal(DEFAULT_DRIVER.createReader((InputStream)in), o);
            return object;
        }
    }

    public void write(Object o) throws IOException {
        this.mkdirs();
        AtomicFileWriter w = new AtomicFileWriter(this.file);
        try {
            w.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            this.xs.toXML(o, (Writer)w);
            w.commit();
        }
        catch (StreamException e) {
            throw new IOException(e);
        }
        finally {
            w.abort();
        }
    }

    public boolean exists() {
        return this.file.exists();
    }

    public void delete() {
        this.file.delete();
    }

    public void mkdirs() {
        this.file.getParentFile().mkdirs();
    }

    public String toString() {
        return this.file.toString();
    }

    public Reader readRaw() throws IOException {
        return new InputStreamReader((InputStream)new FileInputStream(this.file), this.sniffEncoding());
    }

    public String asString() throws IOException {
        StringWriter w = new StringWriter();
        this.writeRawTo(w);
        return w.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRawTo(Writer w) throws IOException {
        try (Reader r = this.readRaw();){
            Util.copyStream(r, w);
        }
    }

    /*
     * Exception decompiling
     */
    public String sniffEncoding() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static {
        JAXP.setNamespaceAware(true);
    }
}

