/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.AbstractItem;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;

@Extension
public class DeleteJobCommand
extends CLICommand {
    @Argument(usage="Name of the job(s) to delete", required=true, multiValued=true)
    private List<String> jobs;

    @Override
    public String getShortDescription() {
        return Messages.DeleteJobCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.getActiveInstance();
        HashSet<String> hs = new HashSet<String>();
        hs.addAll(this.jobs);
        for (String job_s : hs) {
            AbstractItem job = null;
            try {
                job = (AbstractItem)jenkins.getItemByFullName(job_s);
                if (job == null) {
                    throw new IllegalArgumentException("No such job '" + job_s + "'");
                }
                job.checkPermission(AbstractItem.DELETE);
                job.delete();
            }
            catch (Exception e) {
                if (hs.size() == 1) {
                    throw e;
                }
                String errorMsg = String.format(job_s + ": " + e.getMessage(), new Object[0]);
                this.stderr.println(errorMsg);
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            throw new AbortException("Error occured while performing this command, see previous stderr output.");
        }
        return 0;
    }
}

