/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.AbstractBuildRangeCommand;
import hudson.cli.Messages;
import hudson.model.AbstractBuild;
import hudson.scm.ChangeLogSet;
import hudson.util.QuotedStringTokenizer;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;

@Extension
public class ListChangesCommand
extends AbstractBuildRangeCommand {
    @Option(name="-format", usage="Controls how the output from this command is printed.")
    public Format format = Format.PLAIN;

    @Override
    public String getShortDescription() {
        return Messages.ListChangesCommand_ShortDescription();
    }

    @Override
    protected int act(List<AbstractBuild<?, ?>> builds) throws IOException {
        switch (this.format) {
            case XML: {
                PrintWriter w = new PrintWriter(this.stdout);
                w.println("<changes>");
                for (AbstractBuild<?, ?> build : builds) {
                    w.println("<build number='" + build.getNumber() + "'>");
                    ChangeLogSet<ChangeLogSet.Entry> cs = build.getChangeSet();
                    Model p = new ModelBuilder().get(cs.getClass());
                    p.writeTo(cs, Flavor.XML.createDataWriter(cs, (Writer)w));
                    w.println("</build>");
                }
                w.println("</changes>");
                w.flush();
                break;
            }
            case CSV: {
                for (AbstractBuild<?, ?> build : builds) {
                    ChangeLogSet<ChangeLogSet.Entry> cs = build.getChangeSet();
                    for (ChangeLogSet.Entry e : cs) {
                        this.stdout.printf("%s,%s%n", QuotedStringTokenizer.quote(e.getAuthor().getId()), QuotedStringTokenizer.quote(e.getMsg()));
                    }
                }
                break;
            }
            case PLAIN: {
                for (AbstractBuild<?, ?> build : builds) {
                    ChangeLogSet<ChangeLogSet.Entry> cs = build.getChangeSet();
                    for (ChangeLogSet.Entry e : cs) {
                        this.stdout.printf("%s\t%s%n", e.getAuthor(), e.getMsg());
                        for (String p : e.getAffectedPaths()) {
                            this.stdout.println("  " + p);
                        }
                    }
                }
                break;
            }
        }
        return 0;
    }

    static enum Format {
        XML,
        CSV,
        PLAIN;

    }
}

