/*
 * Decompiled with CFR 0.152.
 */
package hudson.diagnosis;

import hudson.Extension;
import hudson.diagnosis.Messages;
import hudson.model.MultiStageTimeSeries;
import hudson.model.PeriodicWork;
import hudson.util.ColorPalette;
import hudson.util.TimeUnit2;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.ArrayList;
import java.util.List;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.QueryParameter;

@Extension
@Symbol(value={"memoryUsage"})
public final class MemoryUsageMonitor
extends PeriodicWork {
    public final MemoryGroup heap;
    public final MemoryGroup nonHeap;

    public MemoryUsageMonitor() {
        List<MemoryPoolMXBean> pools = ManagementFactory.getMemoryPoolMXBeans();
        this.heap = new MemoryGroup(pools, MemoryType.HEAP);
        this.nonHeap = new MemoryGroup(pools, MemoryType.NON_HEAP);
    }

    @Override
    public long getRecurrencePeriod() {
        return TimeUnit2.SECONDS.toMillis(10L);
    }

    @Override
    protected void doRun() {
        this.heap.update();
        this.nonHeap.update();
    }

    public final class MemoryGroup {
        private final List<MemoryPoolMXBean> pools = new ArrayList<MemoryPoolMXBean>();
        public final MultiStageTimeSeries used = new MultiStageTimeSeries(Messages._MemoryUsageMonitor_USED(), ColorPalette.RED, 0.0f, 0.0f);
        public final MultiStageTimeSeries max = new MultiStageTimeSeries(Messages._MemoryUsageMonitor_TOTAL(), ColorPalette.BLUE, 0.0f, 0.0f);

        private MemoryGroup(List<MemoryPoolMXBean> pools, MemoryType type) {
            for (MemoryPoolMXBean pool : pools) {
                if (pool.getType() != type) continue;
                this.pools.add(pool);
            }
        }

        private void update() {
            long used = 0L;
            long max = 0L;
            for (MemoryPoolMXBean pool : this.pools) {
                MemoryUsage usage = pool.getCollectionUsage();
                if (usage == null) continue;
                used += usage.getUsed();
                max += usage.getMax();
            }
            this.used.update(used /= 1024L);
            this.max.update(max /= 1024L);
        }

        public MultiStageTimeSeries.TrendChart doGraph(@QueryParameter String type) throws IOException {
            return MultiStageTimeSeries.createTrendChart(MultiStageTimeSeries.TimeScale.parse(type), this.used, this.max);
        }
    }
}

