/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.XStream;
import hudson.DescriptorExtensionList;
import hudson.XmlFile;
import hudson.model.AbstractItem;
import hudson.model.Descriptor;
import hudson.model.FreeStyleProject;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.listeners.ItemListener;
import hudson.remoting.Callable;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.util.DescriptorList;
import hudson.util.EditDistance;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.DirectlyModifiableTopLevelItemGroup;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class Items {
    @Deprecated
    public static final List<TopLevelItemDescriptor> LIST = new DescriptorList<TopLevelItem>(TopLevelItem.class);
    private static final ThreadLocal<Boolean> updatingByXml = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    public static final XStream XSTREAM = new XStream2();
    public static final XStream2 XSTREAM2 = (XStream2)XSTREAM;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, T extends Throwable> V whileUpdatingByXml(Callable<V, T> callable) throws T {
        updatingByXml.set(true);
        try {
            Object object = callable.call();
            return (V)object;
        }
        finally {
            updatingByXml.set(false);
        }
    }

    public static boolean currentlyUpdatingByXml() {
        return updatingByXml.get();
    }

    public static DescriptorExtensionList<TopLevelItem, TopLevelItemDescriptor> all() {
        return Jenkins.getInstance().getDescriptorList(TopLevelItem.class);
    }

    public static List<TopLevelItemDescriptor> all(ItemGroup c) {
        return Items.all(Jenkins.getAuthentication(), c);
    }

    public static List<TopLevelItemDescriptor> all(Authentication a, ItemGroup c) {
        ArrayList<TopLevelItemDescriptor> result = new ArrayList<TopLevelItemDescriptor>();
        ACL acl = c instanceof AccessControlled ? ((AccessControlled)((Object)c)).getACL() : Jenkins.getInstance().getACL();
        for (TopLevelItemDescriptor d : Items.all()) {
            if (!acl.hasCreatePermission(a, c, d) || !d.isApplicableIn(c)) continue;
            result.add(d);
        }
        return result;
    }

    public static TopLevelItemDescriptor getDescriptor(String fqcn) {
        return (TopLevelItemDescriptor)Descriptor.find(Items.all(), fqcn);
    }

    public static String toNameList(Collection<? extends Item> items) {
        StringBuilder buf = new StringBuilder();
        for (Item item : items) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(item.getFullName());
        }
        return buf.toString();
    }

    @Deprecated
    public static <T extends Item> List<T> fromNameList(String list, Class<T> type) {
        return Items.fromNameList(null, list, type);
    }

    public static <T extends Item> List<T> fromNameList(ItemGroup context, @Nonnull String list, @Nonnull Class<T> type) {
        Jenkins jenkins = Jenkins.getInstance();
        ArrayList<T> r = new ArrayList<T>();
        if (jenkins == null) {
            return r;
        }
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            T item;
            String fullName = tokens.nextToken().trim();
            if (!StringUtils.isNotEmpty((String)fullName) || (item = jenkins.getItem(fullName, context, type)) == null) continue;
            r.add(item);
        }
        return r;
    }

    public static String getCanonicalName(ItemGroup context, String path) {
        int i;
        String[] c = context.getFullName().split("/");
        String[] p = path.split("/");
        Stack<String> name = new Stack<String>();
        for (i = 0; i < c.length; ++i) {
            if (i == 0 && c[i].equals("")) continue;
            name.push(c[i]);
        }
        for (i = 0; i < p.length; ++i) {
            if (i == 0 && p[i].equals("")) {
                name.clear();
                continue;
            }
            if (p[i].equals("..")) {
                if (name.size() == 0) {
                    throw new IllegalArgumentException(String.format("Illegal relative path '%s' within context '%s'", path, context.getFullName()));
                }
                name.pop();
                continue;
            }
            if (p[i].equals(".")) continue;
            name.push(p[i]);
        }
        return StringUtils.join(name, (char)'/');
    }

    public static String computeRelativeNamesAfterRenaming(String oldFullName, String newFullName, String relativeNames, ItemGroup context) {
        StringTokenizer tokens = new StringTokenizer(relativeNames, ",");
        ArrayList<String> newValue = new ArrayList<String>();
        while (tokens.hasMoreTokens()) {
            String relativeName = tokens.nextToken().trim();
            String canonicalName = Items.getCanonicalName(context, relativeName);
            if (canonicalName.equals(oldFullName) || canonicalName.startsWith(oldFullName + '/')) {
                String newCanonicalName = newFullName + canonicalName.substring(oldFullName.length());
                if (relativeName.startsWith("/")) {
                    newValue.add("/" + newCanonicalName);
                    continue;
                }
                newValue.add(Items.getRelativeNameFrom(newCanonicalName, context.getFullName()));
                continue;
            }
            newValue.add(relativeName);
        }
        return StringUtils.join(newValue, (String)",");
    }

    static String getRelativeNameFrom(String itemFullName, String groupFullName) {
        String[] itemFullNameA = itemFullName.isEmpty() ? new String[]{} : itemFullName.split("/");
        String[] groupFullNameA = groupFullName.isEmpty() ? new String[]{} : groupFullName.split("/");
        int i = 0;
        while (true) {
            if (i == itemFullNameA.length) {
                if (i == groupFullNameA.length) {
                    return ".";
                }
                StringBuilder b = new StringBuilder();
                for (int j = 0; j < groupFullNameA.length - itemFullNameA.length; ++j) {
                    if (j > 0) {
                        b.append('/');
                    }
                    b.append("..");
                }
                return b.toString();
            }
            if (i == groupFullNameA.length) {
                StringBuilder b = new StringBuilder();
                for (int j = i; j < itemFullNameA.length; ++j) {
                    if (j > i) {
                        b.append('/');
                    }
                    b.append(itemFullNameA[j]);
                }
                return b.toString();
            }
            if (!itemFullNameA[i].equals(groupFullNameA[i])) {
                int j;
                StringBuilder b = new StringBuilder();
                for (j = i; j < groupFullNameA.length; ++j) {
                    if (j > i) {
                        b.append('/');
                    }
                    b.append("..");
                }
                for (j = i; j < itemFullNameA.length; ++j) {
                    b.append('/').append(itemFullNameA[j]);
                }
                return b.toString();
            }
            ++i;
        }
    }

    public static Item load(ItemGroup parent, File dir) throws IOException {
        Item item = (Item)Items.getConfigFile(dir).read();
        item.onLoad(parent, dir.getName());
        return item;
    }

    public static XmlFile getConfigFile(File dir) {
        return new XmlFile(XSTREAM, new File(dir, "config.xml"));
    }

    public static XmlFile getConfigFile(Item item) {
        return Items.getConfigFile(item.getRootDir());
    }

    public static <T extends Item> List<T> getAllItems(ItemGroup root, Class<T> type) {
        ArrayList r = new ArrayList();
        Items.getAllItems(root, type, r);
        return r;
    }

    private static <T extends Item> void getAllItems(ItemGroup root, Class<T> type, List<T> r) {
        ArrayList items = new ArrayList(root.getItems());
        Collections.sort(items, new Comparator<Item>(){

            @Override
            public int compare(Item i1, Item i2) {
                return this.name(i1).compareToIgnoreCase(this.name(i2));
            }

            String name(Item i) {
                String n = i.getName();
                if (i instanceof ItemGroup) {
                    n = n + '/';
                }
                return n;
            }
        });
        for (Item i : items) {
            if (type.isInstance(i) && i.hasPermission(Item.READ)) {
                r.add(type.cast(i));
            }
            if (!(i instanceof ItemGroup)) continue;
            Items.getAllItems((ItemGroup)((Object)i), type, r);
        }
    }

    @CheckForNull
    public static <T extends Item> T findNearest(Class<T> type, String name, ItemGroup context) {
        List<T> projects = Jenkins.getInstance().getAllItems(type);
        String[] names = new String[projects.size()];
        for (int i = 0; i < projects.size(); ++i) {
            names[i] = ((Item)projects.get(i)).getRelativeNameFrom(context);
        }
        String nearest = EditDistance.findNearest(name, names);
        return Jenkins.getInstance().getItem(nearest, context, type);
    }

    public static <I extends AbstractItem> I move(I item, DirectlyModifiableTopLevelItemGroup destination) throws IOException, IllegalArgumentException {
        DirectlyModifiableTopLevelItemGroup oldParent = (DirectlyModifiableTopLevelItemGroup)item.getParent();
        if (oldParent == destination) {
            throw new IllegalArgumentException();
        }
        if (!destination.canAdd((TopLevelItem)((Object)item))) {
            throw new IllegalArgumentException();
        }
        String name = item.getName();
        if (destination.getItem(name) != null) {
            throw new IllegalArgumentException(name + " already exists");
        }
        String oldFullName = item.getFullName();
        File destDir = destination.getRootDirFor(item);
        FileUtils.forceMkdir((File)destDir.getParentFile());
        FileUtils.moveDirectory((File)item.getRootDir(), (File)destDir);
        oldParent.remove((TopLevelItem)((Object)item));
        AbstractItem newItem = (AbstractItem)((Object)destination.add((TopLevelItem)((Object)item), name));
        item.movedTo(destination, newItem, destDir);
        ItemListener.fireLocationChange(newItem, oldFullName);
        return (I)newItem;
    }

    static {
        XSTREAM.alias("project", FreeStyleProject.class);
    }
}

