/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import hudson.scm.SCMRevisionState;
import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class PollingResult
implements Serializable {
    @CheckForNull
    public final SCMRevisionState baseline;
    @CheckForNull
    public final SCMRevisionState remote;
    @Nonnull
    public final Change change;
    public static final PollingResult NO_CHANGES = new PollingResult(Change.NONE);
    public static final PollingResult SIGNIFICANT = new PollingResult(Change.SIGNIFICANT);
    public static final PollingResult BUILD_NOW = new PollingResult(Change.INCOMPARABLE);
    private static final long serialVersionUID = 1L;

    public PollingResult(@CheckForNull SCMRevisionState baseline, @CheckForNull SCMRevisionState remote, @Nonnull Change change) {
        if (change == null) {
            throw new IllegalArgumentException();
        }
        this.baseline = baseline;
        this.remote = remote;
        this.change = change;
    }

    public PollingResult(@Nonnull Change change) {
        this(null, null, change);
    }

    public boolean hasChanges() {
        return this.change.ordinal() > Change.INSIGNIFICANT.ordinal();
    }

    public static enum Change {
        NONE,
        INSIGNIFICANT,
        SIGNIFICANT,
        INCOMPARABLE;

    }
}

