/*
 * Decompiled with CFR 0.152.
 */
package hudson.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class QueryParameterMap {
    private final Map<String, List<String>> store = new HashMap<String, List<String>>();

    public QueryParameterMap(String queryString) {
        if (queryString == null || queryString.length() == 0) {
            return;
        }
        try {
            for (String param : queryString.split("&")) {
                String[] kv = param.split("=");
                String key = URLDecoder.decode(kv[0], "UTF-8");
                String value = URLDecoder.decode(kv[1], "UTF-8");
                List<String> values = this.store.get(key);
                if (values == null) {
                    values = new ArrayList<String>();
                    this.store.put(key, values);
                }
                values.add(value);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public QueryParameterMap(HttpServletRequest req) {
        this(req.getQueryString());
    }

    public String get(String name) {
        List<String> v = this.store.get(name);
        return v != null ? v.get(0) : null;
    }

    public List<String> getAll(String name) {
        List<String> v = this.store.get(name);
        return v != null ? Collections.unmodifiableList(v) : Collections.emptyList();
    }
}

