/*
 * Decompiled with CFR 0.152.
 */
package jenkins.mvn;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.TaskListener;
import hudson.util.IOUtils;
import java.io.File;
import jenkins.mvn.Messages;
import jenkins.mvn.SettingsProvider;
import jenkins.mvn.SettingsProviderDescriptor;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class FilePathSettingsProvider
extends SettingsProvider {
    private final String path;

    @DataBoundConstructor
    public FilePathSettingsProvider(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Override
    public FilePath supplySettings(AbstractBuild<?, ?> build, TaskListener listener) {
        if (StringUtils.isEmpty((String)this.path)) {
            return null;
        }
        try {
            EnvVars env = build.getEnvironment(listener);
            String targetPath = Util.replaceMacro(this.path, build.getBuildVariableResolver());
            targetPath = env.expand(targetPath);
            if (IOUtils.isAbsolute(targetPath)) {
                return new FilePath(new File(targetPath));
            }
            FilePath mrSettings = build.getModuleRoot().child(targetPath);
            FilePath wsSettings = build.getWorkspace().child(targetPath);
            try {
                if (!wsSettings.exists() && mrSettings.exists()) {
                    wsSettings = mrSettings;
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("failed to find settings.xml at: " + wsSettings.getRemote());
            }
            return wsSettings;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to prepare settings.xml");
        }
    }

    @Extension(ordinal=10.0)
    @Symbol(value={"filePath"})
    public static class DescriptorImpl
    extends SettingsProviderDescriptor {
        @Override
        public String getDisplayName() {
            return Messages.FilePathSettingsProvider_DisplayName();
        }
    }
}

